/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.SignificantEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="A General Framework for Increasing the Robustness of PCA-based Correlation Clustering Algorithms", booktitle="Proc. 20th Intl. Conf. on Scientific and Statistical Database Management (SSDBM)", url="https://doi.org/10.1007/978-3-540-69497-7_27", bibkey="DBLP:conf/ssdbm/KriegelKSZ08")
public class AutotuningPCA
extends PCARunner {
    private EigenPairFilter filter;

    public AutotuningPCA(CovarianceMatrixBuilder covarianceMatrixBuilder, EigenPairFilter filter) {
        super(covarianceMatrixBuilder);
        this.filter = filter;
    }

    @Override
    public PCAResult processIds(DBIDs ids, Relation<? extends NumberVector> database) {
        Centroid center = Centroid.make(database, ids);
        ModifiableDoubleDBIDList dres = DBIDUtil.newDistanceDBIDList(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double dist = EuclideanDistanceFunction.STATIC.distance(center, database.get(iter));
            dres.add(dist, iter);
            iter.advance();
        }
        dres.sort();
        return this.processQueryResult(dres, database);
    }

    @Override
    public PCAResult processQueryResult(DoubleDBIDList results, Relation<? extends NumberVector> database) {
        int startk;
        this.assertSortedByDistance(results);
        int dim = RelationUtil.dimensionality(database);
        double[][][] best = new double[dim][][];
        double[] beststrength = new double[dim];
        Arrays.fill(beststrength, -1.0);
        int[] bestk = new int[dim];
        LinkedList<Cand> prev = new LinkedList<Cand>();
        int smooth = 3;
        for (int k = startk = Math.min(4, results.size() - 1); k < results.size(); ++k) {
            double[][] covMat = this.covarianceMatrixBuilder.processQueryResults(results, database);
            EigenvalueDecomposition evd = new EigenvalueDecomposition(covMat);
            double[] evs = AutotuningPCA.reversed((double[])evd.getRealEigenvalues().clone());
            int thisdim = this.filter.filter(evs);
            assert (thisdim > 0 && thisdim <= dim);
            double thisexplain = this.computeExplainedVariance(evs, thisdim);
            prev.add(new Cand(covMat, thisexplain, thisdim));
            if (prev.size() < 2 * smooth + 1) continue;
            boolean samedim = true;
            Iterator it = prev.iterator();
            while (it.hasNext()) {
                if (((Cand)it.next()).dim == thisdim) continue;
                samedim = false;
            }
            if (samedim) {
                double avgexplain = 0.0;
                Iterator it2 = prev.iterator();
                while (it2.hasNext()) {
                    avgexplain += ((Cand)it2.next()).explain;
                }
                if ((avgexplain /= (double)prev.size()) > beststrength[thisdim - 1]) {
                    beststrength[thisdim - 1] = avgexplain;
                    best[thisdim - 1] = ((Cand)prev.get((int)smooth)).m;
                    bestk[thisdim - 1] = k - smooth;
                }
            }
            prev.removeFirst();
        }
        for (int i = 0; i < dim; ++i) {
            if (!(beststrength[i] > 0.0) || bestk[i] == startk + smooth || bestk[i] == results.size() - smooth - 1) continue;
            return this.processCovarMatrix(best[i]);
        }
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processQueryResults(results, database));
    }

    private static double[] reversed(double[] a) {
        Arrays.sort(a);
        int i = 0;
        for (int j = a.length - 1; i < j; ++i, --j) {
            double tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
        return a;
    }

    private double computeExplainedVariance(double[] eigenValues, int filteredEigenPairs) {
        int i;
        double strongsum = 0.0;
        double weaksum = 0.0;
        for (i = 0; i < filteredEigenPairs; ++i) {
            strongsum += eigenValues[i];
        }
        for (i = filteredEigenPairs; i < eigenValues.length; ++i) {
            weaksum += eigenValues[i];
        }
        return strongsum / (strongsum + weaksum);
    }

    private void assertSortedByDistance(DoubleDBIDList results) {
        double dist = -1.0;
        boolean sorted = true;
        DoubleDBIDListIter it = results.iter();
        while (it.valid()) {
            double qr = it.doubleValue();
            if (qr < dist) {
                sorted = false;
            }
            dist = qr;
            it.advance();
        }
        if (!sorted) {
            try {
                ((ModifiableDoubleDBIDList)ModifiableDoubleDBIDList.class.cast(results)).sort();
            }
            catch (ClassCastException | UnsupportedOperationException e) {
                LoggingUtil.warning("WARNING: results not sorted by distance!", e);
            }
        }
    }

    public static class Parameterizer
    extends PCARunner.Parameterizer {
        public static final OptionID PCA_EIGENPAIR_FILTER = new OptionID("autopca.filter", "Filter for selecting eigenvectors during autotuning PCA.");
        private EigenPairFilter filter;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter filterP = new ObjectParameter(PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, SignificantEigenPairFilter.class);
            if (config.grab(filterP)) {
                this.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
        }

        @Override
        protected AutotuningPCA makeInstance() {
            return new AutotuningPCA(this.covarianceMatrixBuilder, this.filter);
        }
    }

    private static class Cand {
        double[][] m;
        double explain;
        int dim;

        Cand(double[][] m, double explain, int dim) {
            this.m = m;
            this.explain = explain;
            this.dim = dim;
        }
    }
}

