/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import java.util.Arrays;

public class PCAFilteredResult
extends PCAResult {
    private double[] strongEigenvalues;
    private double[][] strongEigenvectors;
    private double[] weakEigenvalues;
    private double[][] weakEigenvectors;
    private double explainedVariance;
    private double[][] m_hat;
    private double[][] m_czech;

    public PCAFilteredResult(EigenPair[] eigenPairs, int numstrong, double big, double small) {
        super(eigenPairs);
        int i;
        int dim = eigenPairs[0].getEigenvector().length;
        double sumStrongEigenvalues = 0.0;
        double sumWeakEigenvalues = 0.0;
        this.strongEigenvalues = new double[numstrong];
        this.strongEigenvectors = new double[numstrong][];
        for (i = 0; i < numstrong; ++i) {
            EigenPair eigenPair = eigenPairs[i];
            this.strongEigenvectors[i] = eigenPair.getEigenvector();
            this.strongEigenvalues[i] = eigenPair.getEigenvalue();
            sumStrongEigenvalues += this.strongEigenvalues[i];
        }
        this.weakEigenvalues = new double[dim - numstrong];
        this.weakEigenvectors = new double[dim - numstrong][];
        i = numstrong;
        int j = 0;
        while (i < dim) {
            EigenPair eigenPair = eigenPairs[i];
            this.weakEigenvectors[j] = eigenPair.getEigenvector();
            this.weakEigenvalues[j] = eigenPair.getEigenvalue();
            sumWeakEigenvalues += this.weakEigenvalues[j];
            ++i;
            ++j;
        }
        this.explainedVariance = sumStrongEigenvalues / (sumStrongEigenvalues + sumWeakEigenvalues);
        int localdim = this.strongEigenvalues.length;
        double[] e_hat_d = new double[dim];
        Arrays.fill(e_hat_d, 0, localdim, small);
        Arrays.fill(e_hat_d, localdim, dim, big);
        double[] e_czech_d = new double[dim];
        Arrays.fill(e_czech_d, 0, localdim, big);
        Arrays.fill(e_czech_d, localdim, dim, small);
        double[][] Vt = this.getEigenvectors();
        this.m_hat = VMath.transposeDiagonalTimes(Vt, e_hat_d, Vt);
        this.m_czech = VMath.transposeDiagonalTimes(Vt, e_czech_d, Vt);
    }

    public final double[][] getStrongEigenvectors() {
        return this.strongEigenvectors;
    }

    public final double[] getStrongEigenvalues() {
        return this.strongEigenvalues;
    }

    public final double[][] getWeakEigenvectors() {
        return this.weakEigenvectors;
    }

    public final double[] getWeakEigenvalues() {
        return this.weakEigenvalues;
    }

    public final int getCorrelationDimension() {
        return this.strongEigenvalues.length;
    }

    public double getExplainedVariance() {
        return this.explainedVariance;
    }

    public double[][] similarityMatrix() {
        return this.m_hat;
    }

    public double[][] dissimilarityMatrix() {
        return this.m_czech;
    }
}

