/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPair;
import java.util.Arrays;
import java.util.Comparator;

public class PCAResult {
    private EigenPair[] eigenPairs;
    private double[] eigenvalues;
    private double[][] eigenvectors;

    public PCAResult(EigenPair[] eigenPairs) {
        this.eigenPairs = eigenPairs;
        this.eigenvalues = new double[eigenPairs.length];
        this.eigenvectors = new double[eigenPairs.length][];
        for (int i = 0; i < eigenPairs.length; ++i) {
            this.eigenvalues[i] = eigenPairs[i].getEigenvalue();
            this.eigenvectors[i] = eigenPairs[i].getEigenvector();
        }
    }

    public PCAResult(EigenvalueDecomposition evd) {
        this(PCAResult.processDecomposition(evd));
    }

    private static EigenPair[] processDecomposition(EigenvalueDecomposition evd) {
        double[] eigenvalues = evd.getRealEigenvalues();
        double[][] eigenvectors = evd.getV();
        EigenPair[] eigenPairs = new EigenPair[eigenvalues.length];
        for (int i = 0; i < eigenvalues.length; ++i) {
            double e = Math.abs(eigenvalues[i]);
            double[] v = VMath.getCol(eigenvectors, i);
            eigenPairs[i] = new EigenPair(v, e);
        }
        Arrays.sort(eigenPairs, Comparator.reverseOrder());
        return eigenPairs;
    }

    public final double[][] getEigenvectors() {
        return this.eigenvectors;
    }

    public final double[] getEigenvalues() {
        return this.eigenvalues;
    }

    public final EigenPair[] getEigenPairs() {
        return this.eigenPairs;
    }
}

