/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class PCARunner {
    protected CovarianceMatrixBuilder covarianceMatrixBuilder;

    public PCARunner(CovarianceMatrixBuilder covarianceMatrixBuilder) {
        this.covarianceMatrixBuilder = covarianceMatrixBuilder;
    }

    public PCAResult processIds(DBIDs ids, Relation<? extends NumberVector> database) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processIds(ids, database));
    }

    public PCAResult processQueryResult(DoubleDBIDList results, Relation<? extends NumberVector> database) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processQueryResults(results, database));
    }

    public PCAResult processCovarMatrix(double[][] covarMatrix) {
        EigenvalueDecomposition evd = new EigenvalueDecomposition(covarMatrix);
        return this.processEVD(evd);
    }

    public PCAResult processEVD(EigenvalueDecomposition evd) {
        return new PCAResult(evd);
    }

    public CovarianceMatrixBuilder getCovarianceMatrixBuilder() {
        return this.covarianceMatrixBuilder;
    }

    public void setCovarianceMatrixBuilder(CovarianceMatrixBuilder covarianceBuilder) {
        this.covarianceMatrixBuilder = covarianceBuilder;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PCARUNNER_ID = new OptionID("pca.variant", "The class to compute (filtered) PCA.");
        public static final OptionID PCA_COVARIANCE_MATRIX = new OptionID("pca.covariance", "Class used to compute the covariance matrix.");
        protected CovarianceMatrixBuilder covarianceMatrixBuilder;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter covarianceP = new ObjectParameter(PCA_COVARIANCE_MATRIX, (Class<?>)CovarianceMatrixBuilder.class, StandardCovarianceMatrixBuilder.class);
            if (config.grab(covarianceP)) {
                this.covarianceMatrixBuilder = (CovarianceMatrixBuilder)covarianceP.instantiateClass(config);
            }
        }

        @Override
        protected PCARunner makeInstance() {
            return new PCARunner(this.covarianceMatrixBuilder);
        }
    }
}

