/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@References(value={@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE Int. Conf. on Data Mining (ICDM 2012)", url="https://doi.org/10.1109/ICDM.2012.21", bibkey="DBLP:conf/icdm/KriegelKSZ12"), @Reference(title="Random sample consensus: a paradigm for model fitting with applications to image analysis and automated cartography", authors="M. A. Fischler, R. C. Bolles", booktitle="Communications of the ACM 24(6)", url="https://doi.org/10.1145/358669.358692", bibkey="DBLP:journals/cacm/FischlerB81")})
public class RANSACCovarianceMatrixBuilder
implements CovarianceMatrixBuilder {
    int iterations = 1000;
    RandomFactory rnd;

    public RANSACCovarianceMatrixBuilder(int iterations, RandomFactory rnd) {
        this.iterations = iterations;
        this.rnd = rnd;
    }

    @Override
    public double[][] processIds(DBIDs ids, Relation<? extends NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        HashSetModifiableDBIDs best = DBIDUtil.newHashSet();
        HashSetModifiableDBIDs support = DBIDUtil.newHashSet();
        double tresh = ChiSquaredDistribution.quantile(0.85, dim);
        CovarianceMatrix cv = new CovarianceMatrix(dim);
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < this.iterations; ++i) {
            ModifiableDBIDs sample = DBIDUtil.randomSample(ids, dim + 1, random);
            cv.reset();
            DBIDIter it = sample.iter();
            while (it.valid()) {
                cv.put(relation.get(it));
                it.advance();
            }
            double[] centroid = cv.getMeanVector();
            double[][] p = VMath.inverse(cv.destroyToSampleMatrix());
            support.clear();
            DBIDIter id = ids.iter();
            while (id.valid()) {
                double[] vec = VMath.minusEquals(relation.get(id).toArray(), centroid);
                double sqlen = VMath.transposeTimesTimes(vec, p, vec);
                if (sqlen < tresh) {
                    support.add(id);
                }
                id.advance();
            }
            if (support.size() > best.size()) {
                HashSetModifiableDBIDs swap = best;
                best = support;
                support = swap;
            }
            if (support.size() >= ids.size()) break;
        }
        return CovarianceMatrix.make(relation, best.size() > dim ? best : ids).destroyToSampleMatrix();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ITER_ID = new OptionID("ransacpca.iterations", "The number of iterations to perform.");
        public static final OptionID SEED_ID = new OptionID("ransacpca.seed", "Random seed (optional).");
        int iterations = 1000;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            super.makeOptions(config);
            IntParameter iterP = (IntParameter)new IntParameter(ITER_ID, 1000).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(iterP)) {
                this.iterations = iterP.intValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RANSACCovarianceMatrixBuilder makeInstance() {
            return new RANSACCovarianceMatrixBuilder(this.iterations, this.rnd);
        }
    }
}

