/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions.ConstantWeight;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions.WeightFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="Weighted Covariance Matrix / PCA")
@Description(value="A PCA modification by using weights while building the covariance matrix, to obtain more stable results")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="A General Framework for Increasing the Robustness of PCA-based Correlation Clustering Algorithms", booktitle="Proc. 20th Intl. Conf. on Scientific and Statistical Database Management (SSDBM)", url="https://doi.org/10.1007/978-3-540-69497-7_27", bibkey="DBLP:conf/ssdbm/KriegelKSZ08")
public class WeightedCovarianceMatrixBuilder
implements CovarianceMatrixBuilder {
    protected WeightFunction weightfunction;
    private PrimitiveDistanceFunction<? super NumberVector> weightDistance = EuclideanDistanceFunction.STATIC;

    public WeightedCovarianceMatrixBuilder(WeightFunction weightfunction) {
        this.weightfunction = weightfunction;
    }

    @Override
    public double[][] processIds(DBIDs ids, Relation<? extends NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        CovarianceMatrix cmat = new CovarianceMatrix(dim);
        Centroid centroid = Centroid.make(relation, ids);
        double maxdist = 0.0;
        double stddev = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double distance = this.weightDistance.distance(centroid, relation.get(iter));
            stddev += distance * distance;
            if (distance > maxdist) {
                maxdist = distance;
            }
            iter.advance();
        }
        if (maxdist == 0.0) {
            maxdist = 1.0;
        }
        stddev = FastMath.sqrt(stddev / (double)ids.size());
        iter = ids.iter();
        while (iter.valid()) {
            NumberVector obj = relation.get(iter);
            double distance = this.weightDistance.distance(centroid, obj);
            double weight = this.weightfunction.getWeight(distance, maxdist, stddev);
            cmat.put(obj, weight);
            iter.advance();
        }
        return cmat.destroyToPopulationMatrix();
    }

    @Override
    public double[][] processQueryResults(DoubleDBIDList results, Relation<? extends NumberVector> database, int k) {
        double dist;
        int dim = RelationUtil.dimensionality(database);
        CovarianceMatrix cmat = new CovarianceMatrix(dim);
        double maxdist = 0.0;
        double stddev = 0.0;
        int i = 0;
        DoubleDBIDListIter it = results.iter();
        for (k = k <= results.size() ? k : results.size(); it.valid() && i < k; ++k) {
            dist = it.doubleValue();
            stddev += dist * dist;
            if (dist > maxdist) {
                maxdist = dist;
            }
            it.advance();
        }
        if (maxdist == 0.0) {
            maxdist = 1.0;
        }
        stddev = FastMath.sqrt(stddev / (double)k);
        i = 0;
        it = results.iter();
        while (it.valid() && i < k) {
            dist = it.doubleValue();
            NumberVector obj = database.get(it);
            double weight = this.weightfunction.getWeight(dist, maxdist, stddev);
            cmat.put(obj, weight);
            it.advance();
            ++k;
        }
        return cmat.destroyToPopulationMatrix();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID WEIGHT_ID = new OptionID("pca.weight", "Weight function to use in weighted PCA.");
        protected WeightFunction weightfunction = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter weightfunctionP = new ObjectParameter(WEIGHT_ID, (Class<?>)WeightFunction.class, ConstantWeight.class);
            if (config.grab(weightfunctionP)) {
                this.weightfunction = (WeightFunction)weightfunctionP.instantiateClass(config);
            }
        }

        @Override
        protected WeightedCovarianceMatrixBuilder makeInstance() {
            return new WeightedCovarianceMatrixBuilder(this.weightfunction);
        }
    }
}

