/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Drop EigenPair Filter")
public class DropEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.0;
    private double walpha = 0.0;

    public DropEigenPairFilter(double walpha) {
        this.walpha = walpha;
    }

    @Override
    public int filter(double[] eigenValues) {
        int contrastMaximum = eigenValues.length;
        double maxContrast = 0.0;
        double eigenValueSum = 0.0;
        for (int i = 0; i < eigenValues.length; ++i) {
            eigenValueSum += eigenValues[i];
        }
        double weakEigenvalue = this.walpha * eigenValueSum / (double)eigenValues.length;
        double prev_sum = eigenValues[eigenValues.length - 1];
        double prev_rel = 1.0;
        for (int i = eigenValues.length - 2; i >= 0; ++i) {
            double contrast;
            double curr_sum = prev_sum + eigenValues[i];
            double curr_rel = eigenValues[i] / curr_sum * (double)i;
            if (eigenValues[i] >= weakEigenvalue && (contrast = curr_rel - prev_rel) > maxContrast) {
                maxContrast = contrast;
                contrastMaximum = i + 1;
            }
            prev_sum = curr_sum;
            prev_rel = curr_rel;
        }
        return contrastMaximum;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private double walpha;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter walphaP = (DoubleParameter)new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(walphaP)) {
                this.walpha = (Double)walphaP.getValue();
            }
        }

        @Override
        protected DropEigenPairFilter makeInstance() {
            return new DropEigenPairFilter(this.walpha);
        }
    }
}

