/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="First n Eigenpair filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and marks the first n eigenpairs as strong eigenpairs.")
public class FirstNEigenPairFilter
implements EigenPairFilter {
    private int n;

    public FirstNEigenPairFilter(int n) {
        this.n = n;
    }

    @Override
    public int filter(double[] eigenValues) {
        return this.n < eigenValues.length ? this.n : eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_N = new OptionID("pca.filter.n", "The number of strong eigenvectors: n eigenvectors with the n highest eigenvalues are marked as strong eigenvectors.");
        protected int n = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter nP = (IntParameter)new IntParameter(EIGENPAIR_FILTER_N).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(nP)) {
                this.n = nP.intValue();
            }
        }

        @Override
        protected FirstNEigenPairFilter makeInstance() {
            return new FirstNEigenPairFilter(this.n);
        }
    }
}

