/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;

@Title(value="Limit-based Eigenpair Filter")
@Description(value="Filters all eigenvalues, which are lower than a given value.")
public class LimitEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_DELTA = 0.01;
    private double delta;
    private boolean absolute;

    public LimitEigenPairFilter(double delta, boolean absolute) {
        this.delta = delta;
        this.absolute = absolute;
    }

    @Override
    public int filter(double[] eigenValues) {
        double limit = this.absolute ? this.delta : eigenValues[0] * this.delta;
        for (int i = 0; i < eigenValues.length; ++i) {
            double eigenValue = Math.abs(eigenValues[i]);
            if (!(eigenValue < limit)) continue;
            return i;
        }
        return eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_ABSOLUTE = new OptionID("pca.filter.absolute", "Flag to mark delta as an absolute value.");
        public static final OptionID EIGENPAIR_FILTER_DELTA = new OptionID("pca.filter.delta", "The threshold for strong Eigenvalues. If not otherwise specified, delta is a relative value w.r.t. the (absolute) highest Eigenvalues and has to be a double between 0 and 1. To mark delta as an absolute value, use the option -" + EIGENPAIR_FILTER_ABSOLUTE.getName() + ".");
        private double delta;
        private boolean absolute;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag absoluteF = new Flag(EIGENPAIR_FILTER_ABSOLUTE);
            if (config.grab(absoluteF)) {
                this.absolute = absoluteF.isTrue();
            }
            DoubleParameter deltaP = (DoubleParameter)new DoubleParameter(EIGENPAIR_FILTER_DELTA).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (!this.absolute) {
                ((DoubleParameter)deltaP.setDefaultValue((Object)0.01)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            }
            if (config.grab(deltaP)) {
                this.delta = deltaP.doubleValue();
            }
        }

        @Override
        protected LimitEigenPairFilter makeInstance() {
            return new LimitEigenPairFilter(this.delta, this.absolute);
        }
    }
}

