/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Percentage based Eigenpair filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns the first eigenpairs, whose sum of eigenvalues is higher than the given percentage of the sum of all eigenvalues.")
public class PercentageEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_ALPHA = 0.85;
    private double alpha;

    public PercentageEigenPairFilter(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public int filter(double[] eigenValues) {
        double totalSum = 0.0;
        for (int i = 0; i < eigenValues.length; ++i) {
            totalSum += eigenValues[i];
        }
        double currSum = 0.0;
        for (int i = 0; i < eigenValues.length; ++i) {
            if (!((currSum += eigenValues[i]) / totalSum >= this.alpha)) continue;
            return i + 1;
        }
        return eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALPHA_ID = new OptionID("pca.filter.alpha", "The share (0.0 to 1.0) of variance that needs to be explained by the 'strong' eigenvectors. The filter class will choose the number of strong eigenvectors by this share.");
        private double alpha;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter alphaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.85).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (config.grab(alphaP)) {
                this.alpha = alphaP.doubleValue();
            }
        }

        @Override
        protected PercentageEigenPairFilter makeInstance() {
            return new PercentageEigenPairFilter(this.alpha);
        }
    }
}

