/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Progressive Eigenpair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns the first eigenpairs, whose sum of eigenvalues explains more than the a certain percentage of the unexpected variance, where the percentage increases with subspace dimensionality.")
public class ProgressiveEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_PALPHA = 0.5;
    public static final double DEFAULT_WALPHA = 0.95;
    private double palpha;
    private double walpha;

    public ProgressiveEigenPairFilter(double palpha, double walpha) {
        this.palpha = palpha;
        this.walpha = walpha;
    }

    @Override
    public int filter(double[] eigenValues) {
        double totalSum = 0.0;
        for (int i = 0; i < eigenValues.length; ++i) {
            totalSum += eigenValues[i];
        }
        double expectedVariance = totalSum / (double)eigenValues.length * this.walpha;
        double currSum = 0.0;
        for (int i = 0; i < eigenValues.length - 1 && !(eigenValues[i] < expectedVariance); ++i) {
            double alpha = 1.0 - (1.0 - this.palpha) * (1.0 - (double)(i + 1) / (double)eigenValues.length);
            if (!((currSum += eigenValues[i]) / totalSum >= alpha)) continue;
            return i + 1;
        }
        return eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_PALPHA = new OptionID("pca.filter.progressivealpha", "The share (0.0 to 1.0) of variance that needs to be explained by the 'strong' eigenvectors. The filter class will choose the number of strong eigenvectors by this share.");
        private double palpha;
        private double walpha;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter walphaP;
            super.makeOptions(config);
            DoubleParameter palphaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(EIGENPAIR_FILTER_PALPHA, 0.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (config.grab(palphaP)) {
                this.palpha = (Double)palphaP.getValue();
            }
            if (config.grab(walphaP = (DoubleParameter)new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.95).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.walpha = (Double)walphaP.getValue();
            }
        }

        @Override
        protected ProgressiveEigenPairFilter makeInstance() {
            return new ProgressiveEigenPairFilter(this.palpha, this.walpha);
        }
    }
}

