/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Relative EigenPair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns those eigenpairs, whose eigenvalue is above the average ('expected') eigenvalue of the remaining eigenvectors.")
public class RelativeEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_RALPHA = 1.1;
    private double ralpha;

    public RelativeEigenPairFilter(double ralpha) {
        this.ralpha = ralpha;
    }

    @Override
    public int filter(double[] eigenValues) {
        double eigenValueSum = eigenValues[eigenValues.length - 1];
        for (int i = eigenValues.length - 2; i >= 0; --i) {
            double needEigenvalue = (eigenValueSum += eigenValues[i]) / (double)(eigenValues.length - i) * this.ralpha;
            if (!(eigenValues[i] >= needEigenvalue)) continue;
            return i + 1;
        }
        return eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_RALPHA = new OptionID("pca.filter.relativealpha", "The sensitivity niveau for weak eigenvectors: An eigenvector which is at less than the given share of the statistical average variance is considered weak.");
        protected double ralpha;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter ralphaP = (DoubleParameter)new DoubleParameter(EIGENPAIR_FILTER_RALPHA, 1.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(ralphaP)) {
                this.ralpha = (Double)ralphaP.getValue();
            }
        }

        @Override
        protected RelativeEigenPairFilter makeInstance() {
            return new RelativeEigenPairFilter(this.ralpha);
        }
    }
}

