/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Significant EigenPair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and looks for the maxmimum contrast of current Eigenvalue / average of remaining Eigenvalues.")
public class SignificantEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.0;
    private double walpha;

    public SignificantEigenPairFilter(double walpha) {
        this.walpha = walpha;
    }

    @Override
    public int filter(double[] eigenPairs) {
        int contrastMaximum = eigenPairs.length;
        double maxContrast = 0.0;
        double eigenValueSum = 0.0;
        for (int i = 0; i < eigenPairs.length; ++i) {
            eigenValueSum += eigenPairs[i];
        }
        double weakEigenvalue = eigenValueSum / (double)eigenPairs.length * this.walpha;
        double currSum = eigenPairs[eigenPairs.length - 1];
        for (int i = eigenPairs.length - 2; i >= 0; --i) {
            currSum += eigenPairs[i];
            if (eigenPairs[i] < weakEigenvalue) break;
            double contrast = eigenPairs[i] / (currSum / (double)(eigenPairs.length - i));
            if (!(contrast > maxContrast)) continue;
            maxContrast = contrast;
            contrastMaximum = i + 1;
        }
        return contrastMaximum;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private double walpha;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter walphaP = (DoubleParameter)new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(walphaP)) {
                this.walpha = (Double)walphaP.getValue();
            }
        }

        @Override
        protected SignificantEigenPairFilter makeInstance() {
            return new SignificantEigenPairFilter(this.walpha);
        }
    }
}

