/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter;

import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Weak Eigenpair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns those eigenpairs, whose eigenvalue is above the average ('expected') eigenvalue.")
public class WeakEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.95;
    private double walpha;

    public WeakEigenPairFilter(double walpha) {
        this.walpha = walpha;
    }

    @Override
    public int filter(double[] eigenValues) {
        double totalSum = 0.0;
        for (int i = 0; i < eigenValues.length; ++i) {
            totalSum += eigenValues[i];
        }
        double expectEigenvalue = totalSum / (double)eigenValues.length * this.walpha;
        for (int i = 0; i < eigenValues.length; ++i) {
            if (!(eigenValues[i] <= expectEigenvalue)) continue;
            return i;
        }
        return eigenValues.length;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_WALPHA = new OptionID("pca.filter.weakalpha", "The minimum strength of the statistically expected variance (1/n) share an eigenvector needs to have to be considered 'strong'.");
        private double walpha;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter walphaP = (DoubleParameter)new DoubleParameter(EIGENPAIR_FILTER_WALPHA, 0.95).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(walphaP)) {
                this.walpha = (Double)walphaP.getValue();
            }
        }

        @Override
        protected WeakEigenPairFilter makeInstance() {
            return new WeakEigenPairFilter(this.walpha);
        }
    }
}

