/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.weightfunctions.WeightFunction;
import net.jafama.FastMath;

public final class GaussStddevWeight
implements WeightFunction {
    private static final double scaling = 1.0 / MathUtil.SQRTTWOPI;

    @Override
    public double getWeight(double distance, double max, double stddev) {
        if (stddev <= 0.0) {
            return 1.0;
        }
        double normdistance = distance / stddev;
        return scaling * FastMath.exp(-0.5 * normdistance * normdistance) / stddev;
    }
}

