/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.scales;

import java.text.NumberFormat;
import java.util.Locale;
import net.jafama.FastMath;

public class LinearScale {
    public static final int MAXTICKS = 31;
    private final double ZOOMFACTOR = Math.log10(31.0);
    private double min;
    private double max;
    private double res;
    private int log10res;
    private double delta;

    public LinearScale(double min, double max) {
        if (max < min) {
            double tmp = max;
            max = min;
            min = tmp;
        }
        this.delta = max - min;
        if (this.delta <= Double.MIN_NORMAL) {
            this.delta = 1.0;
        }
        this.log10res = (int)Math.ceil(Math.log10(this.delta) - this.ZOOMFACTOR);
        this.res = FastMath.pow(10.0, this.log10res);
        this.min = Math.floor(min / this.res + 0.001) * this.res;
        this.max = Math.ceil(max / this.res - 0.001) * this.res;
        if (this.min == this.max) {
            this.max = this.min + this.res;
        }
        this.delta = this.max - this.min;
        if (this.delta <= Double.MIN_NORMAL) {
            this.delta = 1.0;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getRes() {
        return this.res;
    }

    public double getLog10Res() {
        return this.log10res;
    }

    public double getScaled(double val) {
        return (val - this.min) / this.delta;
    }

    public double getUnscaled(double val) {
        return val * this.delta + this.min;
    }

    public double getRelativeScaled(double val) {
        return val / this.delta;
    }

    public double getRelativeUnscaled(double val) {
        return val * this.delta;
    }

    public double getScaled(double val, double smin, double smax) {
        return this.getScaled(val) * (smax - smin) + smin;
    }

    public double getUnscaled(double val, double smin, double smax) {
        return this.getUnscaled(val) * (smax - smin) + smin;
    }

    public double getRelativeScaled(double val, double smax, double smin) {
        return this.getRelativeScaled(val) * (smax - smin);
    }

    public double getRelativeUnscaled(double val, double smin, double smax) {
        return this.getRelativeUnscaled(val) * (smax - smin);
    }

    public String formatValue(double val) {
        NumberFormat fmt = NumberFormat.getInstance(Locale.US);
        fmt.setMaximumFractionDigits(-this.log10res);
        return fmt.format(val);
    }

    public String toString() {
        return "LinearScale[" + this.min + ", " + this.max + "]";
    }
}

