/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.scales;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;

public final class Scales {
    private Scales() {
    }

    public static LinearScale[] calcScales(Relation<? extends SpatialComparable> rel) {
        int dim = RelationUtil.dimensionality(rel);
        DoubleMinMax[] minmax = DoubleMinMax.newArray(dim);
        LinearScale[] scales = new LinearScale[dim];
        DBIDIter iditer = rel.iterDBIDs();
        while (iditer.valid()) {
            double mi;
            int d;
            SpatialComparable v = rel.get(iditer);
            if (v instanceof NumberVector) {
                for (d = 0; d < dim; ++d) {
                    mi = v.getMin(d);
                    if (mi != mi) continue;
                    minmax[d].put(mi);
                }
            } else {
                for (d = 0; d < dim; ++d) {
                    double ma;
                    mi = v.getMin(d);
                    if (mi == mi) {
                        minmax[d].put(mi);
                    }
                    if ((ma = v.getMax(d)) != ma) continue;
                    minmax[d].put(ma);
                }
            }
            iditer.advance();
        }
        for (int d = 0; d < dim; ++d) {
            scales[d] = new LinearScale(minmax[d].getMin(), minmax[d].getMax());
        }
        return scales;
    }
}

