/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Comparator;
import java.util.List;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM 18(9)", url="https://doi.org/10.1145/361002.361007", bibkey="DBLP:journals/cacm/Bentley75")
public class BinarySplitSpatialSorter
implements SpatialSorter {
    public static final BinarySplitSpatialSorter STATIC = new BinarySplitSpatialSorter();

    @Override
    public void sort(List<? extends SpatialComparable> objs, int start, int end, double[] minmax, int[] dims) {
        int numdim = dims != null ? dims.length : minmax.length >>> 1;
        this.binarySplitSort(objs, start, end, 0, numdim, dims, new Sorter(0));
    }

    private void binarySplitSort(List<? extends SpatialComparable> objs, int start, int end, int depth, int numdim, int[] dims, Sorter comp) {
        int mid = start + (end - start >>> 1);
        comp.setDimension(dims != null ? dims[depth] : depth);
        QuickSelect.quickSelect(objs, comp, start, end, mid);
        int nextdim = (depth + 1) % numdim;
        if (start < mid - 1) {
            this.binarySplitSort(objs, start, mid, nextdim, numdim, dims, comp);
        }
        if (mid + 2 < end) {
            this.binarySplitSort(objs, mid + 1, end, nextdim, numdim, dims, comp);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BinarySplitSpatialSorter makeInstance() {
            return STATIC;
        }
    }

    private static class Sorter
    implements Comparator<SpatialComparable> {
        int dim;

        public Sorter(int dim) {
            this.dim = dim;
        }

        public void setDimension(int dim) {
            this.dim = dim;
        }

        @Override
        public int compare(SpatialComparable o1, SpatialComparable o2) {
            double v1 = o1.getMin(this.dim) + o1.getMax(this.dim);
            double v2 = o2.getMin(this.dim) + o2.getMax(this.dim);
            return Double.compare(v1, v2);
        }
    }
}

