/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Reference(authors="D. Hilbert", title="Ueber die stetige Abbildung einer Linie auf ein Fl\u00e4chenst\u00fcck", booktitle="Mathematische Annalen, 38(3)", url="http://resolver.sub.uni-goettingen.de/purl?GDZPPN002253135", bibkey="journals/mathann/Hilbert1891")
public class HilbertSpatialSorter
implements SpatialSorter {
    public static final HilbertSpatialSorter STATIC = new HilbertSpatialSorter();

    @Override
    public void sort(List<? extends SpatialComparable> objs, int start, int end, double[] minmax, int[] dims) {
        int dim = dims != null ? dims.length : minmax.length >> 1;
        ArrayList<HilbertRef> tmp = new ArrayList<HilbertRef>(end - start);
        int[] buf = new int[dim];
        for (int i = start; i < end; ++i) {
            SpatialComparable v = objs.get(i);
            for (int d = 0; d < dim; ++d) {
                int ed = dims != null ? dims[d] : d;
                int ed2 = ed << 1;
                double val = (v.getMin(ed) + v.getMax(ed)) * 0.5;
                val = 2.147483647E9 * ((val - minmax[ed2]) / (minmax[ed2 + 1] - minmax[ed2]));
                buf[d] = (int)val;
            }
            tmp.add(new HilbertRef(v, HilbertSpatialSorter.coordinatesToHilbert(buf, 31, 1)));
        }
        Collections.sort(tmp);
        List<? extends SpatialComparable> cobjs = objs;
        for (int i = start; i < end; ++i) {
            cobjs.set(i, ((HilbertRef)tmp.get((int)(i - start))).vec);
        }
    }

    public static long[] coordinatesToHilbert(long[] coords, int bitsperdim, int offset) {
        int numdim = coords.length;
        int numbits = numdim * bitsperdim;
        long[] output = BitsUtil.zero(numbits);
        int rotation = 0;
        long[] refl = BitsUtil.zero(numdim);
        for (int i = 0; i < bitsperdim; ++i) {
            long[] hist = HilbertSpatialSorter.interleaveBits(coords, i + offset);
            long[] bits = BitsUtil.copy(hist);
            BitsUtil.xorI(bits, refl);
            BitsUtil.cycleRightI(bits, rotation, numdim);
            int nextrot = (rotation + BitsUtil.numberOfTrailingZerosSigned(bits) + 2) % numdim;
            BitsUtil.invgrayI(bits);
            BitsUtil.orI(output, bits, numbits - (i + 1) * numdim);
            refl = hist;
            BitsUtil.flipI(refl, rotation);
            if (!BitsUtil.get(bits, 0)) {
                BitsUtil.flipI(refl, (nextrot - 1 + numdim) % numdim);
            }
            rotation = nextrot;
        }
        return output;
    }

    public static long[] coordinatesToHilbert(int[] coords, int bitsperdim, int offset) {
        int numdim = coords.length;
        int numbits = numdim * bitsperdim;
        long[] output = BitsUtil.zero(numbits);
        int rotation = 0;
        long[] refl = BitsUtil.zero(numdim);
        for (int i = 0; i < bitsperdim; ++i) {
            long[] hist = HilbertSpatialSorter.interleaveBits(coords, i + offset);
            long[] bits = BitsUtil.copy(hist);
            BitsUtil.xorI(bits, refl);
            BitsUtil.cycleRightI(bits, rotation, numdim);
            int nextrot = (rotation + BitsUtil.numberOfTrailingZerosSigned(bits) + 2) % numdim;
            BitsUtil.invgrayI(bits);
            BitsUtil.orI(output, bits, numbits - (i + 1) * numdim);
            refl = hist;
            BitsUtil.flipI(refl, rotation);
            if (!BitsUtil.get(bits, 0)) {
                BitsUtil.flipI(refl, (nextrot - 1 + numdim) % numdim);
            }
            rotation = nextrot;
        }
        return output;
    }

    public static long[] coordinatesToHilbert(short[] coords, int bitsperdim, int offset) {
        int numdim = coords.length;
        int numbits = numdim * bitsperdim;
        long[] output = BitsUtil.zero(numbits);
        int rotation = 0;
        long[] refl = BitsUtil.zero(numdim);
        for (int i = 0; i < bitsperdim; ++i) {
            long[] hist = HilbertSpatialSorter.interleaveBits(coords, i + offset);
            long[] bits = BitsUtil.copy(hist);
            BitsUtil.xorI(bits, refl);
            BitsUtil.cycleRightI(bits, rotation, numdim);
            int nextrot = (rotation + BitsUtil.numberOfTrailingZerosSigned(bits) + 2) % numdim;
            BitsUtil.invgrayI(bits);
            BitsUtil.orI(output, bits, numbits - (i + 1) * numdim);
            refl = hist;
            BitsUtil.flipI(refl, rotation);
            if (!BitsUtil.get(bits, 0)) {
                BitsUtil.flipI(refl, (nextrot - 1 + numdim) % numdim);
            }
            rotation = nextrot;
        }
        return output;
    }

    public static long[] coordinatesToHilbert(byte[] coords, int bitsperdim, int offset) {
        int numdim = coords.length;
        int numbits = numdim * bitsperdim;
        long[] output = BitsUtil.zero(numbits);
        int rotation = 0;
        long[] refl = BitsUtil.zero(numdim);
        for (int i = 0; i < bitsperdim; ++i) {
            long[] hist = HilbertSpatialSorter.interleaveBits(coords, i + offset);
            long[] bits = BitsUtil.copy(hist);
            BitsUtil.xorI(bits, refl);
            BitsUtil.cycleRightI(bits, rotation, numdim);
            int nextrot = (rotation + BitsUtil.numberOfTrailingZerosSigned(bits) + 2) % numdim;
            BitsUtil.invgrayI(bits);
            BitsUtil.orI(output, bits, numbits - (i + 1) * numdim);
            refl = hist;
            BitsUtil.flipI(refl, rotation);
            if (!BitsUtil.get(bits, 0)) {
                BitsUtil.flipI(refl, (nextrot - 1 + numdim) % numdim);
            }
            rotation = nextrot;
        }
        return output;
    }

    public static long[] interleaveBits(long[] coords, int iter) {
        int numdim = coords.length;
        long[] bitset = BitsUtil.zero(numdim);
        long mask = 1L << 63 - iter;
        for (int dim = 0; dim < numdim; ++dim) {
            if ((coords[dim] & mask) == 0L) continue;
            BitsUtil.setI(bitset, dim);
        }
        return bitset;
    }

    public static long[] interleaveBits(int[] coords, int iter) {
        int numdim = coords.length;
        long[] bitset = BitsUtil.zero(numdim);
        long mask = 1L << 31 - iter;
        for (int dim = 0; dim < numdim; ++dim) {
            if (((long)coords[dim] & mask) == 0L) continue;
            BitsUtil.setI(bitset, dim);
        }
        return bitset;
    }

    public static long[] interleaveBits(short[] coords, int iter) {
        int numdim = coords.length;
        long[] bitset = BitsUtil.zero(numdim);
        long mask = 1L << 15 - iter;
        for (int dim = 0; dim < numdim; ++dim) {
            if (((long)coords[dim] & mask) == 0L) continue;
            BitsUtil.setI(bitset, dim);
        }
        return bitset;
    }

    public static long[] interleaveBits(byte[] coords, int iter) {
        int numdim = coords.length;
        long[] bitset = BitsUtil.zero(numdim);
        long mask = 1L << 7 - iter;
        for (int dim = 0; dim < numdim; ++dim) {
            if (((long)coords[dim] & mask) == 0L) continue;
            BitsUtil.setI(bitset, dim);
        }
        return bitset;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HilbertSpatialSorter makeInstance() {
            return STATIC;
        }
    }

    private static class HilbertRef
    implements Comparable<HilbertRef> {
        protected SpatialComparable vec;
        protected long[] bits;

        protected HilbertRef(SpatialComparable vec, long[] bits) {
            this.vec = vec;
            this.bits = bits;
        }

        @Override
        public int compareTo(HilbertRef o) {
            return BitsUtil.compare(this.bits, o.bits);
        }
    }
}

