/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.ZCurveSpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;

@Reference(authors="G. Peano", title="Sur une courbe, qui remplit toute une aire plane", booktitle="Mathematische Annalen 36(1)", url="http://resolver.sub.uni-goettingen.de/purl?GDZPPN002252376", bibkey="journals/mathann/Peano1890")
public class PeanoSpatialSorter
implements SpatialSorter {
    public static final PeanoSpatialSorter STATIC = new PeanoSpatialSorter();

    @Override
    public void sort(List<? extends SpatialComparable> objs, int start, int end, double[] minmax, int[] dims) {
        this.peanoSort(objs, start, end, minmax, dims, 0, BitsUtil.zero(minmax.length >> 1), false);
    }

    protected void peanoSort(List<? extends SpatialComparable> objs, int start, int end, double[] mms, int[] dims, int depth, long[] bits, boolean desc) {
        int fsplit;
        boolean inv;
        int numdim = dims != null ? dims.length : mms.length >> 1;
        int edim = dims != null ? dims[depth] : depth;
        double min = mms[2 * edim];
        double max = mms[2 * edim + 1];
        double tfirst = (min + min + max) / 3.0;
        double tsecond = (min + max + max) / 3.0;
        if (max - tsecond < 1.0E-10 || tsecond - tfirst < 1.0E-10 || tfirst - min < 1.0E-10) {
            boolean ok = false;
            for (int d = 0; d < numdim; ++d) {
                int d2 = (dims != null ? dims[d] : d) << 1;
                if (!(mms[d2 + 1] - mms[d2] >= 1.0E-10)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
        }
        int ssplit = !(inv = BitsUtil.get(bits, edim) ^ desc) ? ((fsplit = ZCurveSpatialSorter.pivotizeList1D(objs, start, end, edim, tfirst, false)) < end - 1 ? ZCurveSpatialSorter.pivotizeList1D(objs, fsplit, end, edim, tsecond, false) : fsplit) : ((fsplit = ZCurveSpatialSorter.pivotizeList1D(objs, start, end, edim, tsecond, true)) < end - 1 ? ZCurveSpatialSorter.pivotizeList1D(objs, fsplit, end, edim, tfirst, true) : fsplit);
        int nextdim = (depth + 1) % numdim;
        if (start < fsplit - 1) {
            mms[2 * edim] = !inv ? min : tsecond;
            mms[2 * edim + 1] = !inv ? tfirst : max;
            this.peanoSort(objs, start, fsplit, mms, dims, nextdim, bits, desc);
        }
        if (fsplit < ssplit - 1) {
            BitsUtil.flipI(bits, edim);
            mms[2 * edim] = tfirst;
            mms[2 * edim + 1] = tsecond;
            this.peanoSort(objs, fsplit, ssplit, mms, dims, nextdim, bits, !desc);
            BitsUtil.flipI(bits, edim);
        }
        if (ssplit < end - 1) {
            mms[2 * edim] = !inv ? tsecond : min;
            mms[2 * edim + 1] = !inv ? max : tfirst;
            this.peanoSort(objs, ssplit, end, mms, dims, nextdim, bits, desc);
        }
        mms[2 * edim] = min;
        mms[2 * edim + 1] = max;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected PeanoSpatialSorter makeInstance() {
            return STATIC;
        }
    }
}

