/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import java.util.Iterator;
import java.util.List;

public interface SpatialSorter {
    default public void sort(List<? extends SpatialComparable> objs) {
        double[] mms = SpatialSorter.computeMinMax(objs);
        this.sort(objs, 0, objs.size(), mms, null);
    }

    public void sort(List<? extends SpatialComparable> var1, int var2, int var3, double[] var4, int[] var5);

    public static double[] computeMinMax(Iterable<? extends SpatialComparable> objs) {
        Iterator<? extends SpatialComparable> it = objs.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute minimum and maximum of empty list.");
        }
        SpatialComparable first = it.next();
        int dim = first.getDimensionality();
        double[] mm = new double[dim << 1];
        int d2 = 0;
        for (int d = 0; d < dim; ++d) {
            mm[d2++] = first.getMin(d);
            mm[d2++] = first.getMax(d);
        }
        while (it.hasNext()) {
            SpatialComparable obj = it.next();
            int d22 = 0;
            for (int d = 0; d < dim; ++d) {
                mm[d22] = MathUtil.min(mm[d22], obj.getMin(d));
                mm[++d22] = MathUtil.max(mm[d22], obj.getMax(d));
                ++d22;
            }
        }
        return mm;
    }
}

