/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;

public class ZCurveSpatialSorter
implements SpatialSorter {
    public static final ZCurveSpatialSorter STATIC = new ZCurveSpatialSorter();
    private static final double STOPVAL = 1.0E-10;

    @Override
    public void sort(List<? extends SpatialComparable> objs, int start, int end, double[] minmax, int[] dims) {
        this.zSort(objs, start, end, minmax, dims, 0);
    }

    protected void zSort(List<? extends SpatialComparable> objs, int start, int end, double[] mms, int[] dims, int depth) {
        double min;
        double spos;
        int numdim = dims != null ? dims.length : mms.length >> 1;
        int edim = dims != null ? dims[depth] : depth;
        double max = mms[2 * edim + 1];
        if (max - (spos = ((min = mms[2 * edim]) + max) / 2.0) < 1.0E-10 || spos - min < 1.0E-10) {
            boolean ok = false;
            for (int d = 0; d < numdim; ++d) {
                int d2 = (dims != null ? dims[d] : d) << 1;
                if (!(mms[d2 + 1] - mms[d2] >= 1.0E-10)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
        }
        int split = ZCurveSpatialSorter.pivotizeList1D(objs, start, end, edim, spos, false);
        assert (start <= split && split <= end);
        int nextdim = (depth + 1) % numdim;
        if (start < split - 1) {
            mms[2 * edim] = min;
            mms[2 * edim + 1] = spos;
            this.zSort(objs, start, split, mms, dims, nextdim);
        }
        if (split < end - 1) {
            mms[2 * edim] = spos;
            mms[2 * edim + 1] = max;
            this.zSort(objs, split, end, mms, dims, nextdim);
        }
        mms[2 * edim] = min;
        mms[2 * edim + 1] = max;
    }

    protected static int pivotizeList1D(List<? extends SpatialComparable> objs, int start, int end, int dim, double threshold, boolean desc) {
        List<? extends SpatialComparable> sobjs = objs;
        threshold = 2.0 * threshold;
        int s = start;
        for (int e = end - 1; s <= e; ++s, --e) {
            double eminmax;
            double sminmax;
            if (!desc) {
                sminmax = ZCurveSpatialSorter.getMinPlusMaxObject(objs, s, dim);
                while (sminmax < threshold && s <= e) {
                    sminmax = ++s <= e ? ZCurveSpatialSorter.getMinPlusMaxObject(objs, s, dim) : Double.POSITIVE_INFINITY;
                }
                eminmax = ZCurveSpatialSorter.getMinPlusMaxObject(objs, e, dim);
                while (eminmax >= threshold && s <= e) {
                    eminmax = --e >= s ? ZCurveSpatialSorter.getMinPlusMaxObject(objs, e, dim) : Double.NEGATIVE_INFINITY;
                }
            } else {
                sminmax = ZCurveSpatialSorter.getMinPlusMaxObject(objs, s, dim);
                while (sminmax > threshold && s <= e) {
                    sminmax = ++s <= e ? ZCurveSpatialSorter.getMinPlusMaxObject(objs, s, dim) : Double.POSITIVE_INFINITY;
                }
                eminmax = ZCurveSpatialSorter.getMinPlusMaxObject(objs, e, dim);
                while (eminmax <= threshold && s <= e) {
                    eminmax = --e >= s ? ZCurveSpatialSorter.getMinPlusMaxObject(objs, e, dim) : Double.NEGATIVE_INFINITY;
                }
            }
            if (s >= e) break;
            sobjs.set(s, sobjs.set(e, sobjs.get(s)));
        }
        return s;
    }

    private static double getMinPlusMaxObject(List<? extends SpatialComparable> objs, int s, int dim) {
        SpatialComparable sobj = objs.get(s);
        return sobj.getMin(dim) + sobj.getMax(dim);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ZCurveSpatialSorter makeInstance() {
            return STATIC;
        }
    }
}

