/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import java.util.Arrays;

public class ZCurveTransformer {
    private final double[] maxValues;
    private final double[] minValues;
    private final int dimensionality;

    public ZCurveTransformer(Relation<? extends NumberVector> relation, DBIDs ids) {
        this.dimensionality = RelationUtil.dimensionality(relation);
        this.minValues = new double[this.dimensionality];
        this.maxValues = new double[this.dimensionality];
        Arrays.fill(this.minValues, Double.POSITIVE_INFINITY);
        Arrays.fill(this.maxValues, Double.NEGATIVE_INFINITY);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            NumberVector vector = relation.get(iter);
            for (int dim = 0; dim < this.dimensionality; ++dim) {
                double dimValue = vector.doubleValue(dim);
                this.minValues[dim] = Math.min(this.minValues[dim], dimValue);
                this.maxValues[dim] = Math.max(this.maxValues[dim], dimValue);
            }
            iter.advance();
        }
    }

    public byte[] asByteArray(NumberVector vector) {
        long[] longValueList = new long[this.dimensionality];
        for (int dim = 0; dim < this.dimensionality; ++dim) {
            double minValue = this.minValues[dim];
            double maxValue = this.maxValues[dim];
            double dimValue = vector.doubleValue(dim);
            dimValue = (dimValue - minValue) / (maxValue - minValue);
            longValueList[dim] = (long)(dimValue * 9.223372036854776E18);
        }
        byte[] bytes = new byte[64 * this.dimensionality * 8];
        int shiftCounter = 0;
        for (int i = 0; i < 64; ++i) {
            for (int dim = 0; dim < this.dimensionality; ++dim) {
                long byteValue = longValueList[dim];
                int localShift = shiftCounter % 8;
                int n = bytes.length - 1 - shiftCounter / 8;
                bytes[n] = (byte)((long)bytes[n] | (byteValue >> i & 1L) << localShift);
                ++shiftCounter;
            }
        }
        return bytes;
    }
}

