/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import java.util.Arrays;
import net.jafama.FastMath;

public class KernelDensityEstimator {
    private double[] dens;
    private double[] var;

    public KernelDensityEstimator(double[] data, double min, double max, KernelDensityFunction kernel, int window, double epsilon) {
        this.process(data, min, max, kernel, window, epsilon);
    }

    private void process(double[] data, double min, double max, KernelDensityFunction kernel, int window, double epsilon) {
        this.dens = new double[data.length];
        this.var = new double[data.length];
        double halfwidth = (max - min) / (double)window * 0.5;
        for (int current = 0; current < data.length; ++current) {
            double contrib;
            double delta;
            int i;
            double value = 0.0;
            for (i = current; i >= 0; --i) {
                delta = Math.abs(data[i] - data[current]) / halfwidth;
                contrib = kernel.density(delta);
                value += contrib;
                if (contrib < epsilon) break;
            }
            for (i = current + 1; i < data.length; ++i) {
                delta = Math.abs(data[i] - data[current]) / halfwidth;
                contrib = kernel.density(delta);
                value += contrib;
                if (contrib < epsilon) break;
            }
            double realwidth = Math.min(data[current] + halfwidth, max) - Math.max(min, data[current] - halfwidth);
            double weight = realwidth / (2.0 * halfwidth);
            this.dens[current] = value / ((double)data.length * realwidth * 0.5);
            this.var[current] = 1.0 / weight;
        }
    }

    public KernelDensityEstimator(double[] data, KernelDensityFunction kernel, double epsilon) {
        boolean needsort = false;
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i - 1] > data[i])) continue;
            needsort = true;
            break;
        }
        if (needsort) {
            data = (double[])data.clone();
            Arrays.sort(data);
        }
        double min = data[0];
        double max = data[data.length - 1];
        int windows = 1 + (int)FastMath.log(data.length);
        this.process(data, min, max, kernel, windows, epsilon);
    }

    public double[] getDensity() {
        return this.dens;
    }

    public double[] getVariance() {
        return this.var;
    }
}

