/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import java.util.List;

public class LinearRegression {
    private double t;
    private double m;

    public LinearRegression(List<DoubleDoublePair> points) {
        double sumy = 0.0;
        double sumx = 0.0;
        double sumxx = 0.0;
        double sumxy = 0.0;
        int gap = 0;
        for (DoubleDoublePair point : points) {
            sumy += point.second;
            ++gap;
            sumx += point.first;
            sumxx += point.first * point.first;
            sumxy += point.first * point.second;
        }
        double Sxy = sumxy - sumx * sumy / (double)gap;
        double Sxx = sumxx - sumx * sumx / (double)gap;
        this.m = Sxy / Sxx;
        this.t = (sumy - this.m * sumx) / (double)gap;
    }

    public double getM() {
        return this.m;
    }

    public double getT() {
        return this.t;
    }
}

