/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;

public class MultipleLinearRegression {
    private final double[] y;
    private final double y_mean;
    private final double[][] x;
    private final double[] b;
    private final double[] e;
    private final double variance;
    private final double[][] xx_inverse;
    private final double ssr;
    private final double sst;

    public MultipleLinearRegression(double[] y, double[][] x) {
        int i;
        if (y.length <= x[0].length) {
            throw new IllegalArgumentException("Number of observed data has to be greater than number of regressors: " + y.length + " > " + x[0].length);
        }
        this.y = y;
        this.x = x;
        double sum = 0.0;
        for (i = 0; i < y.length; ++i) {
            sum += y[i];
        }
        this.y_mean = sum / (double)y.length;
        this.xx_inverse = VMath.inverse(VMath.transposeTimes(x, x));
        this.b = VMath.times(VMath.timesTranspose(this.xx_inverse, x), y);
        this.e = VMath.minus(y, VMath.times(x, this.b));
        sum = 0.0;
        for (i = 0; i < this.e.length; ++i) {
            sum += this.e[i] * this.e[i];
        }
        this.ssr = sum;
        sum = 0.0;
        for (i = 0; i < y.length; ++i) {
            double diff = y[i] - this.y_mean;
            sum += diff * diff;
        }
        this.sst = sum;
        this.variance = this.ssr / (double)(y.length - x[0].length - 1);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder(1000);
        FormatUtil.formatTo(msg.append("x = "), this.x, "[", "]\n", ", ", FormatUtil.NF8);
        FormatUtil.formatTo(msg.append("\ny = "), this.y, ", ", FormatUtil.NF8);
        FormatUtil.formatTo(msg.append("\nb = "), this.b, ", ", FormatUtil.NF8);
        FormatUtil.formatTo(msg.append("\ne = "), this.e, ", ", FormatUtil.NF8);
        return msg.append("error variance = ").append(FormatUtil.NF4.format(this.variance)).toString();
    }

    public double getSumOfSquaresTotal() {
        return this.sst;
    }

    public double getSumOfSquareResiduals() {
        return this.ssr;
    }

    public double[] getEstimatedCoefficients() {
        return this.b;
    }

    public double[] getEstimatedResiduals() {
        return this.e;
    }

    public double coefficientOfDetermination() {
        return 1.0 - this.ssr / this.sst;
    }

    public double estimateY(double[][] x) {
        return VMath.times(x, this.b)[0];
    }

    public double getVariance() {
        return this.variance;
    }
}

