/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.MultipleLinearRegression;

public class PolynomialRegression
extends MultipleLinearRegression {
    public final int p;

    public PolynomialRegression(double[] y, double[] x, int p) {
        super(y, PolynomialRegression.xMatrix(x, p));
        this.p = p;
    }

    private static double[][] xMatrix(double[] x, int p) {
        int n = x.length;
        double[][] result = new double[n][p + 1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p + 1; ++j) {
                result[i][j] = MathUtil.powi(x[i], j);
            }
        }
        return result;
    }

    public double adaptedCoefficientOfDetermination() {
        int n = this.getEstimatedResiduals().length;
        return 1.0 - ((double)n - 1.0) / ((double)n * 1.0 - (double)this.p) * (1.0 - this.coefficientOfDetermination());
    }

    public double estimateY(double x) {
        return super.estimateY(PolynomialRegression.xMatrix(new double[]{x}, this.p));
    }
}

