/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;

@References(value={@Reference(authors="J. R. M. Hosking, J. R. Wallis, E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="https://doi.org/10.1080/00401706.1985.10488049", bibkey="doi:10.1080/00401706.1985.10488049"), @Reference(authors="J. R. M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report", bibkey="tr/ibm/Hosking00")})
public final class ProbabilityWeightedMoments {
    private ProbabilityWeightedMoments() {
    }

    public static <A> double[] alphaPWM(A data, NumberArrayAdapter<?, A> adapter, int nmom) {
        int n = adapter.size(data);
        double[] xmom = new double[nmom];
        double weight = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            double val = adapter.getDouble(data, i);
            xmom[0] = xmom[0] + weight * val;
            int j = 1;
            while (j < nmom) {
                int n2 = j++;
                xmom[n2] = xmom[n2] + (weight *= (double)((n - i - j + 1) / (n - j + 1))) * val;
            }
        }
        return xmom;
    }

    public static <A> double[] betaPWM(A data, NumberArrayAdapter<?, A> adapter, int nmom) {
        int n = adapter.size(data);
        double[] xmom = new double[nmom];
        double weight = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            double val = adapter.getDouble(data, i);
            xmom[0] = xmom[0] + weight * val;
            int j = 1;
            while (j < nmom) {
                int n2 = j++;
                xmom[n2] = xmom[n2] + (weight *= (double)((i - j + 1) / (n - j + 1))) * val;
            }
        }
        return xmom;
    }

    public static <A> double[] alphaBetaPWM(A data, NumberArrayAdapter<?, A> adapter, int nmom) {
        double aweight;
        int n = adapter.size(data);
        double[] xmom = new double[nmom << 1];
        double bweight = aweight = 1.0 / (double)n;
        for (int i = 0; i < n; ++i) {
            double val = adapter.getDouble(data, i);
            xmom[0] = xmom[0] + aweight * val;
            xmom[1] = xmom[1] + bweight * val;
            int j = 1;
            int k = 2;
            while (j < nmom) {
                int n2 = k + 1;
                xmom[n2] = xmom[n2] + (aweight *= (double)((n - i - j + 1) / (n - j + 1))) * val;
                int n3 = k + 1;
                xmom[n3] = xmom[n3] + (bweight *= (double)((i - j + 1) / (n - j + 1))) * val;
                ++j;
                k += 2;
            }
        }
        return xmom;
    }

    public static <A> double[] samLMR(A sorted, NumberArrayAdapter<?, A> adapter, int nmom) {
        int i;
        int n = adapter.size(sorted);
        double[] sum = new double[nmom];
        nmom = n < nmom ? n : nmom;
        for (int i2 = 0; i2 < n; ++i2) {
            double term = adapter.getDouble(sorted, i2);
            if (Double.isInfinite(term) || Double.isNaN(term)) continue;
            sum[0] = sum[0] + term;
            int j = 1;
            int z = i2;
            while (j < nmom) {
                int n2 = j++;
                sum[n2] = sum[n2] + (term *= (double)z);
                --z;
            }
        }
        sum[0] = sum[0] / (double)n;
        double z = n;
        int j = 1;
        while (j < nmom) {
            int n3 = j++;
            sum[n3] = sum[n3] / (z *= (double)(n - j));
        }
        ProbabilityWeightedMoments.normalizeLMR(sum, nmom);
        if (sum[1] == 0.0) {
            for (i = 2; i < nmom; ++i) {
                sum[i] = 0.0;
            }
            return sum;
        }
        i = 2;
        while (i < nmom) {
            int n4 = i++;
            sum[n4] = sum[n4] / sum[1];
        }
        return sum;
    }

    private static void normalizeLMR(double[] sum, int nmom) {
        for (int k = nmom - 1; k >= 1; --k) {
            double p = (k & 1) == 0 ? 1.0 : -1.0;
            double temp = p * sum[0];
            for (int i = 0; i < k; ++i) {
                double ai = (double)i + 1.0;
                temp += (p *= -((double)k + ai) * (double)(k - i) / (ai * ai)) * sum[i + 1];
            }
            sum[k] = temp;
        }
    }
}

