/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDependenceMeasure
implements DependenceMeasure {
    protected static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    protected static <A> double[] computeNormalizedRanks(NumberArrayAdapter<?, A> adapter, A data, int len) {
        int[] s1 = AbstractDependenceMeasure.sortedIndex(adapter, data, len);
        double norm = 0.5 / (double)(len - 1);
        double[] ret = new double[len];
        int i = 0;
        while (i < len) {
            int start = i++;
            double val = adapter.getDouble(data, s1[start]);
            while (i < len && adapter.getDouble(data, s1[i]) <= val) {
                ++i;
            }
            double score = (double)(start + i - 1) * norm;
            for (int j = start; j < i; ++j) {
                ret[s1[j]] = score;
            }
        }
        return ret;
    }

    protected static <A> double[] ranks(NumberArrayAdapter<?, A> adapter, A data, int len) {
        return AbstractDependenceMeasure.ranks(adapter, data, AbstractDependenceMeasure.sortedIndex(adapter, data, len));
    }

    protected static <A> double[] ranks(NumberArrayAdapter<?, A> adapter, A data, int[] idx) {
        int len = idx.length;
        double[] ret = new double[len];
        int i = 0;
        while (i < len) {
            int start = i++;
            double val = adapter.getDouble(data, idx[start]);
            while (i < len && adapter.getDouble(data, idx[i]) <= val) {
                ++i;
            }
            double score = (double)(start + i - 1) * 0.5 + 1.0;
            for (int j = start; j < i; ++j) {
                ret[idx[j]] = score;
            }
        }
        return ret;
    }

    protected static <A> int[] sortedIndex(NumberArrayAdapter<?, A> adapter, A data, int len) {
        int[] s1 = MathUtil.sequence(0, len);
        IntegerArrayQuickSort.sort(s1, (x, y) -> Double.compare(adapter.getDouble(data, x), adapter.getDouble(data, y)));
        return s1;
    }

    protected static <A> int[] discretize(NumberArrayAdapter<?, A> adapter, A data, int len, int bins) {
        double min;
        double max = min = adapter.getDouble(data, 0);
        for (int i = 1; i < len; ++i) {
            double v = adapter.getDouble(data, i);
            if (v < min) {
                min = v;
                continue;
            }
            if (!(v > max)) continue;
            max = v;
        }
        double scale = max > min ? (double)bins / (max - min) : 1.0;
        int[] discData = new int[len];
        for (int i = 0; i < len; ++i) {
            int bin = (int)Math.floor((adapter.getDouble(data, i) - min) * scale);
            discData[i] = bin < 0 ? 0 : (bin >= bins ? bins - 1 : bin);
        }
        return discData;
    }

    protected static int index(int x, int y) {
        assert (x < y) : "Only lower triangle is allowed.";
        return (y * (y - 1) >> 1) + x;
    }

    protected static <A, B> int size(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = adapter1.size(data1);
        if (len != adapter2.size(data2)) {
            throw new IllegalArgumentException("Array sizes do not match!");
        }
        if (len == 0) {
            throw new IllegalArgumentException("Empty array!");
        }
        return len;
    }

    protected static <A> int size(NumberArrayAdapter<?, A> adapter, Collection<? extends A> data) {
        if (data.size() < 2) {
            throw new IllegalArgumentException("Need at least two axes to compute dependence measures.");
        }
        Iterator<A> iter = data.iterator();
        int len = adapter.size(iter.next());
        while (iter.hasNext()) {
            if (len == adapter.size(iter.next())) continue;
            throw new IllegalArgumentException("Array sizes do not match!");
        }
        if (len == 0) {
            throw new IllegalArgumentException("Empty array!");
        }
        return len;
    }
}

