/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;
import net.jafama.FastMath;

public class CorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    private static final Logging LOG = Logging.getLogger(CorrelationDependenceMeasure.class);
    public static final CorrelationDependenceMeasure STATIC = new CorrelationDependenceMeasure();

    protected CorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = CorrelationDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double m1 = 0.0;
        double m2 = 0.0;
        for (int i = 0; i < len; ++i) {
            m1 += adapter1.getDouble(data1, i);
            m2 += adapter2.getDouble(data2, i);
        }
        m1 /= (double)len;
        m2 /= (double)len;
        double v1 = 0.0;
        double v2 = 0.0;
        double cov = 0.0;
        for (int i = 0; i < len; ++i) {
            double d1 = adapter1.getDouble(data1, i) - m1;
            double d2 = adapter2.getDouble(data2, i) - m2;
            v1 += d1 * d1;
            v2 += d2 * d2;
            cov += d1 * d2;
        }
        return cov / FastMath.sqrt(v1 * v2);
    }

    @Override
    public <A> double[] dependence(NumberArrayAdapter<?, A> adapter, List<? extends A> data) {
        int y;
        int dims = data.size();
        int len = CorrelationDependenceMeasure.size(adapter, data);
        double[] means = new double[dims];
        for (int j = 0; j < dims; ++j) {
            double m = 0.0;
            A da = data.get(j);
            for (int i = 0; i < len; ++i) {
                m += adapter.getDouble(da, i);
            }
            means[j] = m / (double)len;
        }
        double[] vst = new double[dims];
        double[] cov = new double[dims * (dims - 1) >> 1];
        double[] buf = new double[dims];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < dims; ++j) {
                buf[j] = adapter.getDouble(data.get(j), i) - means[j];
            }
            int c = 0;
            for (int y2 = 0; y2 < dims; ++y2) {
                for (int x = 0; x < y2; ++x) {
                    int n = c++;
                    cov[n] = cov[n] + buf[x] * buf[y2];
                }
                int n = y2;
                vst[n] = vst[n] + buf[y2] * buf[y2];
            }
        }
        for (y = 0; y < dims; ++y) {
            if (vst[y] == 0.0) {
                LOG.warning("Correlation is not well defined for constant attributes.");
            }
            vst[y] = FastMath.sqrt(vst[y]);
        }
        int c = 0;
        for (y = 1; y < dims; ++y) {
            for (int x = 0; x < y; ++x) {
                cov[c] = cov[c] / (vst[x] * vst[y]);
                ++c;
            }
        }
        return cov;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

