/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="G. J. Sz\u00e9kely, M. L. Rizzo, N. K. Bakirov", title="Measuring and testing dependence by correlation of distances", booktitle="The Annals of Statistics, 35(6), 2769-2794", url="https://doi.org/10.1214/009053607000000505", bibkey="doi:10.1214/009053607000000505")
public class DistanceCorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    public static final DistanceCorrelationDependenceMeasure STATIC = new DistanceCorrelationDependenceMeasure();

    protected DistanceCorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = DistanceCorrelationDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double[] dMatrixA = DistanceCorrelationDependenceMeasure.computeDistances(adapter1, data1);
        double[] dMatrixB = DistanceCorrelationDependenceMeasure.computeDistances(adapter2, data2);
        double dVarA = this.computeDCovar(dMatrixA, dMatrixA, len);
        if (!(dVarA > 0.0)) {
            return 0.0;
        }
        double dVarB = this.computeDCovar(dMatrixB, dMatrixB, len);
        if (!(dVarB > 0.0)) {
            return 0.0;
        }
        double dCovar = this.computeDCovar(dMatrixA, dMatrixB, len);
        return FastMath.sqrt(dCovar / FastMath.sqrt(dVarA * dVarB));
    }

    @Override
    public <A> double[] dependence(NumberArrayAdapter<?, A> adapter, List<? extends A> data) {
        int dims = data.size();
        int len = DistanceCorrelationDependenceMeasure.size(adapter, data);
        double[][] dMatrix = new double[dims][];
        for (int i = 0; i < dims; ++i) {
            dMatrix[i] = DistanceCorrelationDependenceMeasure.computeDistances(adapter, data.get(i));
        }
        double[] dVar = new double[dims];
        for (int i = 0; i < dims; ++i) {
            dVar[i] = this.computeDCovar(dMatrix[i], dMatrix[i], len);
        }
        double[] dCor = new double[dims * (dims - 1) >> 1];
        int c = 0;
        for (int y = 1; y < dims; ++y) {
            for (int x = 0; x < y; ++x) {
                if (!(dVar[x] * dVar[y] > 0.0)) {
                    dCor[c++] = 0.0;
                    continue;
                }
                double dCovar = this.computeDCovar(dMatrix[x], dMatrix[y], len);
                dCor[c++] = FastMath.sqrt(dCovar / FastMath.sqrt(dVar[x] * dVar[y]));
            }
        }
        return dCor;
    }

    protected static <A> double[] computeDistances(NumberArrayAdapter<?, A> adapter, A data) {
        int size = adapter.size(data);
        double[] dMatrix = new double[size * (size + 1) >> 1];
        int c = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                double dx = adapter.getDouble(data, i) - adapter.getDouble(data, j);
                dMatrix[c++] = dx < 0.0 ? -dx : dx;
            }
            ++c;
        }
        DistanceCorrelationDependenceMeasure.doubleCenterMatrix(dMatrix, size);
        return dMatrix;
    }

    public static void doubleCenterMatrix(double[] dMatrix, int size) {
        double[] rowMean = new double[size];
        int c = 0;
        for (int i = 0; i < size; ++i) {
            int j = 0;
            while (j < i) {
                double v = dMatrix[c++];
                int n = i;
                rowMean[n] = rowMean[n] + v;
                int n2 = j++;
                rowMean[n2] = rowMean[n2] + v;
            }
            assert (dMatrix[c] == 0.0);
            ++c;
        }
        double matrixMean = 0.0;
        int i = 0;
        while (i < size) {
            matrixMean += rowMean[i];
            int n = i++;
            rowMean[n] = rowMean[n] / (double)size;
        }
        matrixMean /= (double)(size * size);
        int c2 = 0;
        for (int o = 0; o < size; ++o) {
            for (int p = 0; p <= o; ++p) {
                int n = c2++;
                dMatrix[n] = dMatrix[n] - (rowMean[o] + rowMean[p] - matrixMean);
            }
        }
    }

    protected double computeDCovar(double[] dVarMatrixA, double[] dVarMatrixB, int n) {
        double result = 0.0;
        int c = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                result += 2.0 * dVarMatrixA[c] * dVarMatrixB[c];
                ++c;
            }
            result += dVarMatrixA[c] * dVarMatrixB[c];
            ++c;
        }
        return result / (double)(n * n);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected DistanceCorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

