/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.SinCosTable;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Priority(value=-100)
@Reference(authors="A. Tatu, G. Albuquerque, M. Eisemann, P. Bak, H. Theisel, M. A. Magnor, D. A. Keim", title="Automated Analytical Methods to Support Visual Exploration of High-Dimensional Data", booktitle="IEEE Trans. Visualization and Computer Graphics", url="https://doi.org/10.1109/TVCG.2010.242", bibkey="DBLP:journals/tvcg/TatuAEBTMK11")
public class HSMDependenceMeasure
extends AbstractDependenceMeasure {
    public static final HSMDependenceMeasure STATIC = new HSMDependenceMeasure();
    private static final int STEPS = 52;
    private final int resolution = 512;
    private static final SinCosTable table = SinCosTable.make(104);

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        double v;
        int i;
        double mi;
        int len = HSMDependenceMeasure.size(adapter1, data1, adapter2, data2);
        boolean[][] pic = new boolean[512][512];
        double ma = mi = adapter1.getDouble(data1, 0);
        for (i = 1; i < len; ++i) {
            v = adapter1.getDouble(data1, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off1 = mi;
        double scale1 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        mi = ma = adapter2.getDouble(data2, 0);
        for (i = 1; i < len; ++i) {
            v = adapter2.getDouble(data2, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off2 = mi;
        double scale2 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        for (int i2 = 0; i2 < len; ++i2) {
            double xi = (adapter1.getDouble(data1, i2) - off1) * scale1;
            double xj = (adapter2.getDouble(data2, i2) - off2) * scale2;
            HSMDependenceMeasure.drawLine(0, (int)(512.0 * xi), 511, (int)(512.0 * xj), pic);
        }
        int[][] hough = this.houghTransformation(pic);
        double mean = (double)this.sumMatrix(hough) / 2704.0;
        int abovemean = this.countAboveThreshold(hough, mean);
        return 1.0 - (double)abovemean / 2704.0;
    }

    private long sumMatrix(int[][] mat) {
        long ret = 0L;
        for (int i = 0; i < mat.length; ++i) {
            int[] row = mat[i];
            for (int j = 0; j < row.length; ++j) {
                ret += (long)row[j];
            }
        }
        return ret;
    }

    private int countAboveThreshold(int[][] mat, double threshold) {
        int ret = 0;
        for (int i = 0; i < mat.length; ++i) {
            int[] row = mat[i];
            for (int j = 0; j < row.length; ++j) {
                if (!((double)row[j] >= threshold)) continue;
                ++ret;
            }
        }
        return ret;
    }

    private int[][] houghTransformation(boolean[][] mat) {
        int xres = mat.length;
        int yres = mat[0].length;
        double tscale = 34.32 / (double)(xres + yres);
        int[][] ret = new int[52][52];
        for (int x = 0; x < mat.length; ++x) {
            boolean[] row = mat[x];
            for (int y = 0; y < mat[0].length; ++y) {
                if (!row[y]) continue;
                for (int i = 0; i < 52; ++i) {
                    int d = 26 + (int)(tscale * ((double)x * table.cos(i) + (double)y * table.sin(i)));
                    if (d <= 0 || d >= 52) continue;
                    int[] nArray = ret[d];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        return ret;
    }

    private static void drawLine(int x0, int y0, int x1, int y1, boolean[][] pic) {
        int xres = pic.length;
        int yres = pic[0].length;
        int n = y0 < 0 ? 0 : (y0 = y0 >= yres ? yres - 1 : y0);
        int n2 = y1 < 0 ? 0 : (y1 = y1 >= yres ? yres - 1 : y1);
        int n3 = x0 < 0 ? 0 : (x0 = x0 >= xres ? xres - 1 : x0);
        x1 = x1 < 0 ? 0 : (x1 >= xres ? xres - 1 : x1);
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            pic[x0][y0] = true;
            if (x0 == x1 && y0 == y1) break;
            int e2 = err << 1;
            if (e2 > dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HSMDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

