/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.algorithm.outlier.meta.HiCS;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@References(value={@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13"), @Reference(authors="F. Keller, E. M\u00fcller, K. B\u00f6hm", title="HiCS: High Contrast Subspaces for Density-Based Outlier Ranking", booktitle="Proc. IEEE 28th Int. Conf. on Data Engineering (ICDE 2012)", url="https://doi.org/10.1109/ICDE.2012.88", bibkey="DBLP:conf/icde/KellerMB12")})
public class HiCSDependenceMeasure
extends AbstractDependenceMeasure {
    private int m = 50;
    private double alphasqrt = Math.sqrt(0.1);
    private GoodnessOfFitTest statTest;
    private RandomFactory rnd;

    public HiCSDependenceMeasure(GoodnessOfFitTest statTest, int m, double alpha, RandomFactory rnd) {
        this.statTest = statTest;
        this.m = m;
        this.alphasqrt = Math.sqrt(alpha);
        this.rnd = rnd;
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        double contrast;
        int k;
        int i;
        int len = HiCSDependenceMeasure.size(adapter1, data1, adapter2, data2);
        int windowsize = (int)((double)len * this.alphasqrt);
        Random random = this.rnd.getSingleThreadedRandom();
        int[] s1 = MathUtil.sequence(0, len);
        int[] s2 = MathUtil.sequence(0, len);
        IntegerArrayQuickSort.sort(s1, (x, y) -> Double.compare(adapter1.getDouble(data1, x), adapter1.getDouble(data1, y)));
        IntegerArrayQuickSort.sort(s2, (x, y) -> Double.compare(adapter2.getDouble(data2, x), adapter2.getDouble(data2, y)));
        double[] fullValues = new double[len];
        double[] sampleValues = new double[windowsize];
        double deviationSum = 0.0;
        for (int i2 = 0; i2 < len; ++i2) {
            fullValues[i2] = adapter1.getDouble(data1, i2);
            if (fullValues[i2] == fullValues[i2]) continue;
            throw new AbortException("NaN values are not allowed by this implementation!");
        }
        int half = this.m >> 1;
        for (i = 0; i < half; ++i) {
            int j = random.nextInt(len - windowsize);
            k = 0;
            while (k < windowsize) {
                sampleValues[k] = adapter2.getDouble(data2, j);
                ++k;
                ++j;
            }
            contrast = this.statTest.deviation(fullValues, sampleValues);
            if (Double.isNaN(contrast)) {
                --i;
                continue;
            }
            deviationSum += contrast;
        }
        for (i = 0; i < len; ++i) {
            fullValues[i] = adapter2.getDouble(data2, i);
            if (fullValues[i] == fullValues[i]) continue;
            throw new AbortException("NaN values are not allowed by this implementation!");
        }
        for (i = half; i < this.m; ++i) {
            int j = random.nextInt(len - windowsize);
            k = 0;
            while (k < windowsize) {
                sampleValues[k] = adapter1.getDouble(data1, j);
                ++k;
                ++j;
            }
            contrast = this.statTest.deviation(fullValues, sampleValues);
            if (Double.isNaN(contrast)) {
                --i;
                continue;
            }
            deviationSum += contrast;
        }
        return 1.0 - deviationSum / (double)this.m;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private GoodnessOfFitTest statTest;
        private int m = 50;
        private double alpha = 0.1;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            ObjectParameter testP;
            DoubleParameter alphaP;
            super.makeOptions(config);
            IntParameter mP = (IntParameter)new IntParameter(HiCS.Parameterizer.M_ID, 50).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(mP)) {
                this.m = mP.intValue();
            }
            if (config.grab(alphaP = (DoubleParameter)new DoubleParameter(HiCS.Parameterizer.ALPHA_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.alpha = alphaP.doubleValue();
            }
            if (config.grab(testP = new ObjectParameter(HiCS.Parameterizer.TEST_ID, (Class<?>)GoodnessOfFitTest.class, KolmogorovSmirnovTest.class))) {
                this.statTest = (GoodnessOfFitTest)testP.instantiateClass(config);
            }
            if (config.grab(rndP = new RandomParameter(HiCS.Parameterizer.SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected HiCSDependenceMeasure makeInstance() {
            return new HiCSDependenceMeasure(this.statTest, this.m, this.alpha, this.rnd);
        }
    }
}

