/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="W. Hoeffding", title="A non-parametric test of independence", booktitle="The Annals of Mathematical Statistics 19", url="http://www.jstor.org/stable/2236021", bibkey="journals/mathstat/Hoeffding48")
public class HoeffdingsDDependenceMeasure
extends AbstractDependenceMeasure {
    public static final HoeffdingsDDependenceMeasure STATIC = new HoeffdingsDDependenceMeasure();
    private static final double[] TABVAL = new double[]{0.5297, 0.4918, 0.4565, 0.4236, 0.393, 0.3648, 0.3387, 0.3146, 0.2924, 0.2719, 0.253, 0.2355, 0.2194, 0.2045, 0.1908, 0.1781, 0.1663, 0.1554, 0.1453, 0.1359, 0.1273, 0.1192, 0.1117, 0.1047, 0.0982, 0.0921, 0.0864, 0.0812, 0.0762, 0.0716, 0.0673, 0.0633, 0.0595, 0.056, 0.0527, 0.0496, 0.0467, 0.044, 0.0414, 0.039, 0.0368, 0.0347, 0.0327, 0.0308, 0.0291, 0.0274, 0.0259, 0.0244, 0.023, 0.0217, 0.0205, 0.0194, 0.0183, 0.0173, 0.0163, 0.0154, 0.0145, 0.0137, 0.013, 0.0123, 0.0116, 0.011, 0.0104, 0.0098, 0.0093, 0.0087, 0.0083, 0.0078, 0.0074, 0.007, 0.0066, 0.0063, 0.0059, 0.0056, 0.0053, 0.005, 0.0047, 0.0045, 0.0042, 0.0025, 0.0014, 8.0E-4, 5.0E-4, 3.0E-4, 2.0E-4, 1.0E-4};
    private static final double[] TABPOS = new double[]{1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55, 1.6, 1.65, 1.7, 1.75, 1.8, 1.85, 1.9, 1.95, 2.0, 2.05, 2.1, 2.15, 2.2, 2.25, 2.3, 2.35, 2.4, 2.45, 2.5, 2.55, 2.6, 2.65, 2.7, 2.75, 2.8, 2.85, 2.9, 2.95, 3.0, 3.05, 3.1, 3.15, 3.2, 3.25, 3.3, 3.35, 3.4, 3.45, 3.5, 3.55, 3.6, 3.65, 3.7, 3.75, 3.8, 3.85, 3.9, 3.95, 4.0, 4.05, 4.1, 4.15, 4.2, 4.25, 4.3, 4.35, 4.4, 4.45, 4.5, 4.55, 4.6, 4.65, 4.7, 4.75, 4.8, 4.85, 4.9, 4.95, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5};

    protected HoeffdingsDDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int n = HoeffdingsDDependenceMeasure.size(adapter1, data1, adapter2, data2);
        assert (n > 4) : "Hoeffdings D needs at least 5 elements!";
        if (n <= 4) {
            return Double.NaN;
        }
        double[] r = HoeffdingsDDependenceMeasure.ranks(adapter1, data1, n);
        double[] s = HoeffdingsDDependenceMeasure.ranks(adapter2, data2, n);
        double[] q = HoeffdingsDDependenceMeasure.computeBivariateRanks(adapter1, data1, adapter2, data2, n);
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d1 += q[i] * (q[i] - 1.0);
            d2 += (r[i] - 1.0) * (r[i] - 2.0) * (s[i] - 1.0) * (s[i] - 2.0);
            d3 += (r[i] - 2.0) * (s[i] - 2.0) * q[i];
        }
        double nom = ((double)n - 3.0) * d1 + d2 / (double)(n - 2) - 2.0 * d3;
        double div = (double)n * ((double)n - 1.0) * ((double)n - 3.0) * ((double)n - 4.0);
        double d = 30.0 * nom / div;
        return d < 1.0 ? d : 1.0;
    }

    protected static <A, B> double[] computeBivariateRanks(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2, int len) {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            for (int j = i + 1; j < len; ++j) {
                double xi = adapter1.getDouble(data1, i);
                double xj = adapter1.getDouble(data1, j);
                double yi = adapter2.getDouble(data2, i);
                double yj = adapter2.getDouble(data2, j);
                if (xi < xj) {
                    int n = j;
                    ret[n] = ret[n] + (yi < yj ? 1.0 : (yi == yj ? 0.5 : 0.0));
                    continue;
                }
                if (xj < xi) {
                    int n = i;
                    ret[n] = ret[n] + (yj < yi ? 1.0 : (yj == yi ? 0.5 : 0.0));
                    continue;
                }
                if (yi < yj) {
                    int n = j;
                    ret[n] = ret[n] + 0.5;
                    continue;
                }
                if (yj < yi) {
                    int n = i;
                    ret[n] = ret[n] + 0.5;
                    continue;
                }
                int n = i;
                ret[n] = ret[n] + 0.25;
                int n2 = j;
                ret[n2] = ret[n2] + 0.25;
            }
        }
        return ret;
    }

    public double toPValue(double d, int n) {
        double b = d / 30.0 + 1.0 / (double)(36 * n);
        double z = 48.704545517001215 * (double)n * b;
        if (z < 1.1 || z > 8.5) {
            double e = FastMath.exp(0.3885037 - 1.164879 * z);
            return e > 1.0 ? 1.0 : (e < 0.0 ? 0.0 : e);
        }
        for (int i = 0; i < 86; ++i) {
            if (!(TABPOS[i] >= z)) continue;
            if (TABPOS[i] == z) {
                return TABVAL[i];
            }
            double x1 = TABPOS[i];
            double x0 = TABPOS[i - 1];
            double y1 = TABVAL[i];
            double y0 = TABVAL[i - 1];
            return y0 + (y1 - y0) * (z - x0) / (x1 - x0);
        }
        return -1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HoeffdingsDDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

