/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class JensenShannonEquiwidthDependenceMeasure
extends AbstractDependenceMeasure {
    public static final JensenShannonEquiwidthDependenceMeasure STATIC = new JensenShannonEquiwidthDependenceMeasure();

    protected JensenShannonEquiwidthDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        double min2;
        double min1;
        int len = JensenShannonEquiwidthDependenceMeasure.size(adapter1, data1, adapter2, data2);
        int bins = (int)FastMath.round(FastMath.sqrt(len));
        int maxbin = bins - 1;
        double max1 = min1 = adapter1.getDouble(data1, 0);
        double max2 = min2 = adapter2.getDouble(data2, 0);
        for (int i = 1; i < len; ++i) {
            double vx = adapter1.getDouble(data1, i);
            double vy = adapter2.getDouble(data2, i);
            if (vx < min1) {
                min1 = vx;
            } else if (vx > max1) {
                max1 = vx;
            }
            if (vy < min2) {
                min2 = vy;
                continue;
            }
            if (!(vy > max2)) continue;
            max2 = vy;
        }
        double scale1 = max1 > min1 ? (double)bins / (max1 - min1) : 1.0;
        double scale2 = max2 > min2 ? (double)bins / (max2 - min2) : 1.0;
        int[] margin1 = new int[bins];
        int[] margin2 = new int[bins];
        int[][] counts = new int[bins][bins];
        for (int i = 0; i < len; ++i) {
            int bin1 = (int)FastMath.floor((adapter1.getDouble(data1, i) - min1) * scale1);
            int bin2 = (int)FastMath.floor((adapter2.getDouble(data2, i) - min2) * scale2);
            bin1 = bin1 < bins ? bin1 : maxbin;
            bin2 = bin2 < bins ? bin2 : maxbin;
            int n = bin1;
            margin1[n] = margin1[n] + 1;
            int n2 = bin2;
            margin2[n2] = margin2[n2] + 1;
            int[] nArray = counts[bin1];
            int n3 = bin2;
            nArray[n3] = nArray[n3] + 1;
        }
        double e = 0.0;
        for (int bin1 = 0; bin1 < counts.length; ++bin1) {
            int sum1 = margin1[bin1];
            if (sum1 == 0) continue;
            double pX = (double)sum1 / (double)len;
            int[] row = counts[bin1];
            for (int bin2 = 0; bin2 < row.length; ++bin2) {
                int sum2 = margin2[bin2];
                if (sum2 <= 0) continue;
                int cell = row[bin2];
                double pXY = (double)cell / (double)len;
                double pXpY = pX * (double)sum2 / (double)len;
                double iavg = 2.0 / (pXY + pXpY);
                e += pXY > 0.0 ? pXY * FastMath.log(pXY * iavg) : 0.0;
                e += pXpY * FastMath.log(pXpY * iavg);
            }
        }
        double exp = FastMath.log(bins) + (1.0 + 1.0 / (double)bins) * FastMath.log(2.0 / (double)(bins + 1)) + ((double)bins - 1.0) / (double)bins * MathUtil.LOG2;
        return e / exp;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected JensenShannonEquiwidthDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

