/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="D. Guo", title="Coordinating computational and visual approaches for interactive feature selection and multivariate clustering", booktitle="Information Visualization, 2(4)", url="https://doi.org/10.1057/palgrave.ivs.9500053", bibkey="DBLP:journals/ivs/Guo03")
public class MCEDependenceMeasure
extends AbstractDependenceMeasure {
    public static final MCEDependenceMeasure STATIC = new MCEDependenceMeasure();
    public static final int TARGET = 35;

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = MCEDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double p = MathUtil.log2((double)len / 35.0);
        int power = Math.max(1, (int)Math.floor(p * 0.5));
        int gridsize = 1 << power;
        double loggrid = FastMath.log(gridsize);
        ArrayList<int[]> parts1 = this.buildPartitions(adapter1, data1, len, power);
        ArrayList<int[]> parts2 = this.buildPartitions(adapter2, data2, len, power);
        int[][] res = new int[gridsize][gridsize];
        this.intersectionMatrix(res, parts1, parts2, gridsize);
        return 1.0 - this.getMCEntropy(res, parts1, parts2, len, gridsize, loggrid);
    }

    private <A> ArrayList<int[]> buildPartitions(NumberArrayAdapter<?, A> adapter1, A data1, int len, int depth) {
        int[] idx = new int[len];
        double[] tmp = new double[len];
        for (int i = 0; i < len; ++i) {
            idx[i] = i;
            tmp[i] = adapter1.getDouble(data1, i);
        }
        IntegerArrayQuickSort.sort(idx, (x, y) -> Double.compare(tmp[x], tmp[y]));
        Arrays.sort(tmp);
        ArrayList<int[]> ret = new ArrayList<int[]>(1 << depth);
        this.divide(idx, tmp, ret, 0, tmp.length, depth);
        return ret;
    }

    private void divide(int[] idx, double[] data, ArrayList<int[]> ret, int start, int end, int depth) {
        if (depth == 0) {
            int[] a = Arrays.copyOfRange(idx, start, end);
            Arrays.sort(a);
            ret.add(a);
            return;
        }
        int count = end - start;
        if (count == 0) {
            for (int j = 1 << depth; j > 0; --j) {
                ret.add(new int[0]);
            }
            return;
        }
        double m = 0.0;
        for (int i = start; i < end; ++i) {
            m += data[i];
        }
        int pos = Arrays.binarySearch(data, start, end, m /= (double)count);
        if (pos >= 0) {
            int opt = start + end >> 1;
            while (data[pos] == m) {
                if (pos < opt) {
                    ++pos;
                    continue;
                }
                if (pos > opt) {
                    --pos;
                    continue;
                }
                break;
            }
        } else {
            pos = -pos - 1;
        }
        this.divide(idx, data, ret, start, pos, depth - 1);
        this.divide(idx, data, ret, pos, end, depth - 1);
    }

    private void intersectionMatrix(int[][] res, ArrayList<int[]> partsx, ArrayList<int[]> partsy, int gridsize) {
        for (int x = 0; x < gridsize; ++x) {
            int[] px = partsx.get(x);
            int[] rowx = res[x];
            for (int y = 0; y < gridsize; ++y) {
                int[] py = partsy.get(y);
                rowx[y] = this.intersectionSize(px, py);
            }
        }
    }

    private int intersectionSize(int[] px, int[] py) {
        int i = 0;
        int j = 0;
        int c = 0;
        while (i < px.length && j < py.length) {
            int vx = px[i];
            int vy = py[j];
            if (vx < vy) {
                ++i;
                continue;
            }
            if (vx > vy) {
                ++j;
                continue;
            }
            ++c;
            ++i;
            ++j;
        }
        return c;
    }

    private double getMCEntropy(int[][] mat, ArrayList<int[]> partsx, ArrayList<int[]> partsy, int size, int gridsize, double loggrid) {
        double[] mx = new double[gridsize];
        double[] my = new double[gridsize];
        for (int i = 0; i < gridsize; ++i) {
            double sumx = partsx.get(i).length;
            double sumy = partsy.get(i).length;
            for (int j = 0; j < gridsize; ++j) {
                double px = (double)mat[i][j] / sumx;
                double py = (double)mat[j][i] / sumy;
                if (px > 0.0) {
                    int n = i;
                    mx[n] = mx[n] - px * FastMath.log(px);
                }
                if (!(py > 0.0)) continue;
                int n = i;
                my[n] = my[n] - py * FastMath.log(py);
            }
        }
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < gridsize; ++i) {
            sumx += mx[i] * (double)partsx.get(i).length;
            sumy += my[i] * (double)partsy.get(i).length;
        }
        double max = sumx > sumy ? sumx : sumy;
        return max / ((double)size * loggrid);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MCEDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

