/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Priority(value=-100)
@References(value={@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13"), @Reference(authors="Christian Baumgartner, Claudia Plant, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Subspace Selection for Clustering High-Dimensional Data", booktitle="Proc. IEEE International Conference on Data Mining (ICDM 2004)", url="https://doi.org/10.1109/ICDM.2004.10112", bibkey="DBLP:conf/icdm/BaumgartnerPKKK04")})
public class SURFINGDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SURFINGDependenceMeasure STATIC = new SURFINGDependenceMeasure();

    protected SURFINGDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = SURFINGDependenceMeasure.size(adapter1, data1, adapter2, data2);
        int k = Math.max(1, len / 10);
        double[] knns = new double[len];
        DoubleMaxHeap heap = new DoubleMaxHeap(k);
        double kdistmean = 0.0;
        for (int i = 0; i < len; ++i) {
            double ix = adapter1.getDouble(data1, i);
            double iy = adapter2.getDouble(data2, i);
            heap.clear();
            for (int j = 0; j < len; ++j) {
                if (i == j) continue;
                double jx = adapter1.getDouble(data1, j);
                double jy = adapter2.getDouble(data2, j);
                double dx = ix - jx;
                double dy = iy - jy;
                double dist = dx * dx + dy * dy;
                if (heap.size() < k) {
                    heap.add(dist);
                    continue;
                }
                if (!(dist < heap.peek())) continue;
                heap.replaceTopElement(dist);
            }
            knns[i] = FastMath.sqrt(heap.peek());
            kdistmean += knns[i];
        }
        kdistmean /= (double)len;
        double diff = 0.0;
        int below = 0;
        for (int l = 0; l < knns.length; ++l) {
            double kdist = knns[l];
            if (!(kdist < kdistmean)) continue;
            diff += kdist;
            ++below;
        }
        return below > 0 ? 1.0 - diff / (kdistmean * (double)below) : 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SURFINGDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

