/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class SlopeDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SlopeDependenceMeasure STATIC = new SlopeDependenceMeasure();
    protected static final int PRECISION = 40;
    protected static final double LOG_PRECISION = FastMath.log(40.0);
    protected static final double RESCALE = 20.0;

    protected SlopeDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        double v;
        int i;
        double mi;
        int len = SlopeDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double ma = mi = adapter1.getDouble(data1, 0);
        for (i = 1; i < len; ++i) {
            v = adapter1.getDouble(data1, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off1 = mi;
        double scale1 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        mi = ma = adapter2.getDouble(data2, 0);
        for (i = 1; i < len; ++i) {
            v = adapter2.getDouble(data2, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off2 = mi;
        double scale2 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        int[] angles = new int[40];
        for (int i2 = 0; i2 < len; ++i2) {
            double x = adapter1.getDouble(data1, i2);
            double y = adapter2.getDouble(data2, i2);
            double delta = (x = (x - off1) * scale1) - (y = (y - off2) * scale2) + 1.0;
            int div = (int)Math.round(delta * 20.0);
            int n = div = div < 0 ? 0 : (div >= 40 ? 39 : div);
            angles[n] = angles[n] + 1;
        }
        double entropy = 0.0;
        for (int l = 0; l < 40; ++l) {
            if (angles[l] <= 0) continue;
            double p = (double)angles[l] / (double)len;
            entropy += p * FastMath.log(p);
        }
        return 1.0 + entropy / LOG_PRECISION;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

