/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.SlopeDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. 2013 ACM Int. Conf. on Management of Data (SIGMOD 2013)", url="https://doi.org/10.1145/2463676.2463696", bibkey="DBLP:conf/sigmod/AchtertKSZ13")
public class SlopeInversionDependenceMeasure
extends SlopeDependenceMeasure {
    public static final SlopeInversionDependenceMeasure STATIC = new SlopeInversionDependenceMeasure();

    protected SlopeInversionDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        double v;
        int i;
        double mi;
        int len = SlopeInversionDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double ma = mi = adapter1.getDouble(data1, 0);
        for (i = 1; i < len; ++i) {
            v = adapter1.getDouble(data1, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off1 = mi;
        double scale1 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        mi = ma = adapter2.getDouble(data2, 0);
        for (i = 1; i < len; ++i) {
            v = adapter2.getDouble(data2, i);
            mi = v < mi ? v : mi;
            ma = v > ma ? v : ma;
        }
        double off2 = mi;
        double scale2 = ma > mi ? 1.0 / (ma - mi) : 1.0;
        int[] angles = new int[40];
        int[] angleI = new int[40];
        for (int i2 = 0; i2 < len; ++i2) {
            double x = adapter1.getDouble(data1, i2);
            double y = adapter2.getDouble(data2, i2);
            double delta = (x = (x - off1) * scale1) - (y = (y - off2) * scale2) + 1.0;
            int div = (int)Math.round(delta * 20.0);
            int n = div = div < 0 ? 0 : (div >= 40 ? 39 : div);
            angles[n] = angles[n] + 1;
            delta = x + y;
            div = (int)Math.round(delta * 20.0);
            int n2 = div = div < 0 ? 0 : (div >= 40 ? 39 : div);
            angleI[n2] = angleI[n2] + 1;
        }
        double entropy = 0.0;
        double entropyI = 0.0;
        for (int l = 0; l < 40; ++l) {
            double p;
            if (angles[l] > 0) {
                p = (double)angles[l] / (double)len;
                entropy += p * FastMath.log(p);
            }
            if (angleI[l] <= 0) continue;
            p = (double)angleI[l] / (double)len;
            entropyI += p * FastMath.log(p);
        }
        if (entropy >= entropyI) {
            return 1.0 + entropy / LOG_PRECISION;
        }
        return 1.0 + entropyI / LOG_PRECISION;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeInversionDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

