/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

public class SpearmanCorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    public static final SpearmanCorrelationDependenceMeasure STATIC = new SpearmanCorrelationDependenceMeasure();

    protected SpearmanCorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> adapter1, A data1, NumberArrayAdapter<?, B> adapter2, B data2) {
        int len = SpearmanCorrelationDependenceMeasure.size(adapter1, data1, adapter2, data2);
        double[] ranks1 = SpearmanCorrelationDependenceMeasure.computeNormalizedRanks(adapter1, data1, len);
        double[] ranks2 = SpearmanCorrelationDependenceMeasure.computeNormalizedRanks(adapter2, data2, len);
        double v1 = 0.0;
        double v2 = 0.0;
        double cov = 0.0;
        for (int i = 0; i < len; ++i) {
            double d1 = ranks1[i] - 0.5;
            double d2 = ranks2[i] - 0.5;
            v1 += d1 * d1;
            v2 += d2 * d2;
            cov += d1 * d2;
        }
        return cov / FastMath.sqrt(v1 * v2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SpearmanCorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

