/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

public abstract class AbstractDistribution
implements Distribution {
    protected final Random random;

    public AbstractDistribution(RandomFactory rnd) {
        this.random = rnd.getRandom();
    }

    public AbstractDistribution(Random rnd) {
        this.random = rnd;
    }

    @Override
    public double nextRandom() {
        return this.quantile(this.random.nextDouble());
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("distribution.random", "Random generation data source.");
        public static final OptionID LOCATION_ID = new OptionID("distribution.location", "Distribution location parameter");
        public static final OptionID SCALE_ID = new OptionID("distribution.scale", "Distribution scale parameter");
        public static final OptionID SHAPE_ID = new OptionID("distribution.shape", "Distribution shape parameter");
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            RandomParameter randomP = new RandomParameter(RANDOM_ID);
            if (config.grab(randomP)) {
                this.rnd = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected abstract Distribution makeInstance();
    }
}

