/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class BetaDistribution
extends AbstractDistribution {
    static final double NUM_PRECISION = 1.0E-15;
    static final double SWITCH = 3000.0;
    static final double[] GAUSSLEGENDRE_Y = new double[]{0.0021695375159141994, 0.011413521097787704, 0.027972308950302116, 0.05172701560049242, 0.08250222548434094, 0.12007019910960293, 0.1641528330075247, 0.21442376986779355, 0.27051082840644336, 0.33199876341447887, 0.39843234186401943, 0.46931971407375483, 0.5441360555665797, 0.6223274528803108, 0.7033150046559717, 0.7864991076831345, 0.8712638961906152, 0.9569818015262914};
    static final double[] GAUSSLEGENDRE_W = new double[]{0.005565719664244557, 0.01291594728406542, 0.020181515297735382, 0.027298621498568734, 0.03421381077029954, 0.04087575092364326, 0.04723508349026558, 0.05324471397775969, 0.0588601442453248, 0.06403979735501548, 0.06874532383573641, 0.07294188500565309, 0.07659841064587064, 0.07968782891207167, 0.0821872667043397, 0.08407821897966195, 0.08534668573933872, 0.08598327567039482};
    private final double alpha;
    private final double beta;
    private double logbab;

    public BetaDistribution(double a, double b) {
        this(a, b, (Random)null);
    }

    public BetaDistribution(double a, double b, Random random) {
        super(random);
        if (a <= 0.0 || b <= 0.0) {
            throw new IllegalArgumentException("Invalid parameters for Beta distribution.");
        }
        this.alpha = a;
        this.beta = b;
        this.logbab = BetaDistribution.logBeta(a, b);
    }

    public BetaDistribution(double a, double b, RandomFactory random) {
        super(random);
        if (a <= 0.0 || b <= 0.0) {
            throw new IllegalArgumentException("Invalid parameters for Beta distribution.");
        }
        this.alpha = a;
        this.beta = b;
        this.logbab = BetaDistribution.logBeta(a, b);
    }

    @Override
    public double pdf(double val) {
        return val < 0.0 || val > 1.0 ? 0.0 : (val == 0.0 ? (this.alpha > 1.0 ? 0.0 : (this.alpha < 1.0 ? Double.POSITIVE_INFINITY : this.beta)) : (val == 1.0 ? (this.beta > 1.0 ? 0.0 : (this.beta < 1.0 ? Double.POSITIVE_INFINITY : this.alpha)) : FastMath.exp(-this.logbab + FastMath.log(val) * (this.alpha - 1.0) + FastMath.log1p(-val) * (this.beta - 1.0))));
    }

    @Override
    public double logpdf(double val) {
        return val < 0.0 || val > 1.0 ? Double.NEGATIVE_INFINITY : (val == 0.0 ? (this.alpha > 1.0 ? Double.NEGATIVE_INFINITY : (this.alpha < 1.0 ? Double.POSITIVE_INFINITY : FastMath.log(this.beta))) : (val == 1.0 ? (this.beta > 1.0 ? Double.NEGATIVE_INFINITY : (this.beta < 1.0 ? Double.POSITIVE_INFINITY : FastMath.log(this.alpha))) : -this.logbab + FastMath.log(val) * (this.alpha - 1.0) + FastMath.log1p(-val) * (this.beta - 1.0)));
    }

    @Override
    public double cdf(double x) {
        if (this.alpha <= 0.0 || this.beta <= 0.0 || Double.isNaN(this.alpha) || Double.isNaN(this.beta) || Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (this.alpha > 3000.0 && this.beta > 3000.0) {
            return BetaDistribution.regularizedIncBetaQuadrature(this.alpha, this.beta, x);
        }
        double bt = FastMath.exp(-this.logbab + this.alpha * FastMath.log(x) + this.beta * FastMath.log1p(-x));
        return x < (this.alpha + 1.0) / (this.alpha + this.beta + 2.0) ? bt * BetaDistribution.regularizedIncBetaCF(this.alpha, this.beta, x) / this.alpha : 1.0 - bt * BetaDistribution.regularizedIncBetaCF(this.beta, this.alpha, 1.0 - x) / this.beta;
    }

    @Override
    public double quantile(double x) {
        return x < 0.0 || x > 1.0 || Double.isNaN(x) ? Double.NaN : (x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x > 0.5 ? 1.0 - BetaDistribution.rawQuantile(1.0 - x, this.beta, this.alpha, this.logbab) : BetaDistribution.rawQuantile(x, this.alpha, this.beta, this.logbab))));
    }

    @Override
    public double nextRandom() {
        double x = GammaDistribution.nextRandom(this.alpha, 1.0, this.random);
        double y = GammaDistribution.nextRandom(this.beta, 1.0, this.random);
        return x / (x + y);
    }

    @Override
    public String toString() {
        return "BetaDistribution(alpha=" + this.alpha + ", beta=" + this.beta + ")";
    }

    public static double cdf(double val, double alpha, double beta) {
        return BetaDistribution.regularizedIncBeta(val, alpha, beta);
    }

    public static double pdf(double val, double alpha, double beta) {
        return alpha <= 0.0 || beta <= 0.0 || Double.isNaN(alpha) || Double.isNaN(beta) || Double.isNaN(val) ? Double.NaN : (val < 0.0 || val > 1.0 ? 0.0 : (val == 0.0 ? (alpha > 1.0 ? 0.0 : (alpha < 1.0 ? Double.POSITIVE_INFINITY : beta)) : (val == 1.0 ? (beta > 1.0 ? 0.0 : (beta < 1.0 ? Double.POSITIVE_INFINITY : alpha)) : FastMath.exp(-BetaDistribution.logBeta(alpha, beta) + FastMath.log(val) * (alpha - 1.0) + FastMath.log1p(-val) * (beta - 1.0)))));
    }

    public static double logpdf(double val, double alpha, double beta) {
        return alpha <= 0.0 || beta <= 0.0 || Double.isNaN(alpha) || Double.isNaN(beta) || Double.isNaN(val) ? Double.NaN : (val < 0.0 || val > 1.0 ? Double.NEGATIVE_INFINITY : (val == 0.0 ? (alpha > 1.0 ? Double.NEGATIVE_INFINITY : (alpha < 1.0 ? Double.POSITIVE_INFINITY : FastMath.log(beta))) : (val == 1.0 ? (beta > 1.0 ? Double.NEGATIVE_INFINITY : (beta < 1.0 ? Double.POSITIVE_INFINITY : FastMath.log(alpha))) : -BetaDistribution.logBeta(alpha, beta) + FastMath.log(val) * (alpha - 1.0) + FastMath.log1p(-val) * (beta - 1.0))));
    }

    public static double logBeta(double alpha, double beta) {
        return GammaDistribution.logGamma(alpha) + GammaDistribution.logGamma(beta) - GammaDistribution.logGamma(alpha + beta);
    }

    public static double regularizedIncBeta(double x, double alpha, double beta) {
        if (alpha <= 0.0 || beta <= 0.0 || Double.isNaN(alpha) || Double.isNaN(beta) || Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (alpha > 3000.0 && beta > 3000.0) {
            return BetaDistribution.regularizedIncBetaQuadrature(alpha, beta, x);
        }
        double bt = FastMath.exp(-BetaDistribution.logBeta(alpha, beta) + alpha * FastMath.log(x) + beta * FastMath.log1p(-x));
        return x < (alpha + 1.0) / (alpha + beta + 2.0) ? bt * BetaDistribution.regularizedIncBetaCF(alpha, beta, x) / alpha : 1.0 - bt * BetaDistribution.regularizedIncBetaCF(beta, alpha, 1.0 - x) / beta;
    }

    protected static double regularizedIncBetaCF(double alpha, double beta, double x) {
        double FPMIN = 4.940656458412465E-309;
        double qab = alpha + beta;
        double qap = alpha + 1.0;
        double qam = alpha - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < 4.940656458412465E-309) {
            d = 4.940656458412465E-309;
        }
        double h = d = 1.0 / d;
        for (int m = 1; m < 10000; ++m) {
            int m2 = 2 * m;
            double aa = (double)m * (beta - (double)m) * x / ((qam + (double)m2) * (alpha + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < 4.940656458412465E-309) {
                d = 4.940656458412465E-309;
            }
            if (Math.abs(c = 1.0 + aa / c) < 4.940656458412465E-309) {
                c = 4.940656458412465E-309;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(alpha + (double)m) * (qab + (double)m) * x / ((alpha + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < 4.940656458412465E-309) {
                d = 4.940656458412465E-309;
            }
            if (Math.abs(c = 1.0 + aa / c) < 4.940656458412465E-309) {
                c = 4.940656458412465E-309;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) <= 1.0E-15) break;
        }
        return h;
    }

    protected static double regularizedIncBetaQuadrature(double alpha, double beta, double x) {
        double xu;
        double alphapbeta = alpha + beta;
        double a1 = alpha - 1.0;
        double b1 = beta - 1.0;
        double mu = alpha / alphapbeta;
        double lnmu = FastMath.log(mu);
        double lnmuc = FastMath.log1p(-mu);
        double t = FastMath.sqrt(alpha * beta / (alphapbeta * alphapbeta * (alphapbeta + 1.0)));
        if (x > alpha / alphapbeta) {
            if (x >= 1.0) {
                return 1.0;
            }
            xu = Math.min(1.0, Math.max(mu + 10.0 * t, x + 5.0 * t));
        } else {
            if (x <= 0.0) {
                return 0.0;
            }
            xu = Math.max(0.0, Math.min(mu - 10.0 * t, x - 5.0 * t));
        }
        double sum = 0.0;
        for (int i = 0; i < GAUSSLEGENDRE_Y.length; ++i) {
            t = x + (xu - x) * GAUSSLEGENDRE_Y[i];
            sum += GAUSSLEGENDRE_W[i] * FastMath.exp(a1 * (FastMath.log(t) - lnmu) + b1 * (FastMath.log1p(-t) - lnmuc));
        }
        double ans = sum * (xu - x) * FastMath.exp(a1 * lnmu - GammaDistribution.logGamma(alpha) + b1 * lnmuc - GammaDistribution.logGamma(beta) + GammaDistribution.logGamma(alphapbeta));
        return ans > 0.0 ? 1.0 - ans : -ans;
    }

    public static double quantile(double p, double alpha, double beta) {
        return Double.isNaN(alpha) || Double.isNaN(beta) || Double.isNaN(p) || alpha < 0.0 || beta < 0.0 || p < 0.0 || p > 1.0 ? Double.NaN : (p == 0.0 ? 0.0 : (p == 1.0 ? 1.0 : (p > 0.5 ? 1.0 - BetaDistribution.rawQuantile(1.0 - p, beta, alpha, BetaDistribution.logBeta(beta, alpha)) : BetaDistribution.rawQuantile(p, alpha, beta, BetaDistribution.logBeta(alpha, beta)))));
    }

    protected static double rawQuantile(double p, double alpha, double beta, double logbeta) {
        double x;
        double r;
        double tmp = FastMath.sqrt(-2.0 * FastMath.log(p));
        double y = tmp - (2.30753 + 0.27061 * tmp) / (1.0 + (0.99229 + 0.04481 * tmp) * tmp);
        if (alpha > 1.0 && beta > 1.0) {
            r = (y * y - 3.0) / 6.0;
            double s = 1.0 / (alpha + alpha - 1.0);
            double t = 1.0 / (beta + beta - 1.0);
            double h = 2.0 / (s + t);
            double w = y * FastMath.sqrt(h + r) / h - (t - s) * (r + 0.8333333333333334 - 2.0 / (3.0 * h));
            x = alpha / (alpha + beta * FastMath.exp(w + w));
        } else {
            r = beta + beta;
            double t = 1.0 / (9.0 * beta);
            double a = 1.0 - t + y * FastMath.sqrt(t);
            x = (t = r * a * a * a) <= 0.0 ? 1.0 - FastMath.exp((FastMath.log1p(-p) + FastMath.log(beta) + logbeta) / beta) : ((t = (4.0 * alpha + r - 2.0) / t) <= 1.0 ? FastMath.exp((FastMath.log(p * alpha) + logbeta) / alpha) : 1.0 - 2.0 / (t + 1.0));
        }
        if (x < 3.0E-308 || x > 0.9999999999999998) {
            x = 0.5;
        }
        double ialpha = 1.0 - alpha;
        double ibeta = 1.0 - beta;
        double acu = Math.max(1.0E-300, FastMath.pow(10.0, -13.0 - 2.5 / (alpha * alpha) - 0.5 / (p * p)));
        double prevstep = 0.0;
        double y2 = 0.0;
        double stepsize = 1.0;
        for (int outer = 0; outer < 1000; ++outer) {
            double ynew = BetaDistribution.cdf(x, alpha, beta);
            if (Double.isInfinite(ynew)) {
                return Double.NaN;
            }
            if ((ynew = (ynew - p) * FastMath.exp(logbeta + ialpha * FastMath.log(x) + ibeta * FastMath.log1p(-x))) * y2 <= 0.0) {
                prevstep = Math.max(Math.abs(stepsize), 3.0E-308);
            }
            double g = 1.0;
            double xnew = 0.0;
            for (int inner = 0; inner < 1000; ++inner) {
                stepsize = g * ynew;
                if (Math.abs(stepsize) < prevstep && (xnew = x - stepsize) >= 0.0 && xnew <= 1.0) {
                    if (prevstep <= acu || Math.abs(ynew) <= acu) {
                        return x;
                    }
                    if (xnew != 0.0 && xnew != 1.0) break;
                }
                g /= 3.0;
            }
            if (Math.abs(xnew - x) < 1.0E-15 * x) {
                return x;
            }
            x = xnew;
            y2 = ynew;
        }
        throw new ArithmeticException("Beta quantile computation did not converge.");
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID ALPHA_ID = new OptionID("distribution.beta.alpha", "Beta distribution alpha parameter");
        public static final OptionID BETA_ID = new OptionID("distribution.beta.beta", "Beta distribution beta parameter");
        double alpha;
        double beta;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter betaP;
            super.makeOptions(config);
            DoubleParameter alphaP = new DoubleParameter(ALPHA_ID);
            if (config.grab(alphaP)) {
                this.alpha = alphaP.doubleValue();
            }
            if (config.grab(betaP = new DoubleParameter(BETA_ID))) {
                this.beta = betaP.doubleValue();
            }
        }

        @Override
        protected BetaDistribution makeInstance() {
            return new BetaDistribution(this.alpha, this.beta, this.rnd);
        }
    }
}

