/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class CauchyDistribution
extends AbstractDistribution {
    final double location;
    final double shape;

    public CauchyDistribution(double location, double shape) {
        this(location, shape, (Random)null);
    }

    public CauchyDistribution(double location, double shape, Random random) {
        super(random);
        this.location = location;
        this.shape = shape;
    }

    public CauchyDistribution(double location, double shape, RandomFactory random) {
        super(random);
        this.location = location;
        this.shape = shape;
    }

    public double getLocation() {
        return this.location;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double pdf(double x) {
        return CauchyDistribution.pdf(x, this.location, this.shape);
    }

    @Override
    public double logpdf(double x) {
        return CauchyDistribution.logpdf(x, this.location, this.shape);
    }

    @Override
    public double cdf(double x) {
        return CauchyDistribution.cdf(x, this.location, this.shape);
    }

    @Override
    public double quantile(double x) {
        return CauchyDistribution.quantile(x, this.location, this.shape);
    }

    @Override
    public double nextRandom() {
        double r = this.random.nextDouble() - 0.5;
        return this.location + this.shape / FastMath.tan(Math.PI * r);
    }

    public static double pdf(double x, double location, double shape) {
        double v = (x - location) / shape;
        return 1.0 / (Math.PI * shape * (1.0 + v * v));
    }

    public static double logpdf(double x, double location, double shape) {
        double v = (x - location) / shape;
        return -FastMath.log(Math.PI * shape * (1.0 + v * v));
    }

    public static double cdf(double x, double location, double shape) {
        return FastMath.atan2(x - location, shape) / Math.PI + 0.5;
    }

    public static double quantile(double x, double location, double shape) {
        return x == 0.5 ? location : (x <= 0.5 ? (x <= 0.0 ? (x < 0.0 ? Double.NaN : Double.NEGATIVE_INFINITY) : location - shape / FastMath.tan(Math.PI * x)) : (x >= 1.0 ? (x > 1.0 ? Double.NaN : Double.POSITIVE_INFINITY) : location + shape / FastMath.tan(Math.PI * (1.0 - x))));
    }

    @Override
    public String toString() {
        return "CauchyDistribution(location=" + this.location + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHAPE_ID = new OptionID("distribution.cauchy.shape", "Cauchy distribution gamma/shape parameter.");
        double location;
        double shape;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shapeP;
            super.makeOptions(config);
            DoubleParameter locP = new DoubleParameter(LOCATION_ID);
            if (config.grab(locP)) {
                this.location = locP.doubleValue();
            }
            if (config.grab(shapeP = new DoubleParameter(SHAPE_ID))) {
                this.shape = shapeP.doubleValue();
            }
        }

        @Override
        protected CauchyDistribution makeInstance() {
            return new CauchyDistribution(this.location, this.shape, this.rnd);
        }
    }
}

