/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class ChiDistribution
extends AbstractDistribution {
    private double dof;
    private ChiSquaredDistribution chisq;

    public ChiDistribution(double dof) {
        this(dof, (Random)null);
    }

    public ChiDistribution(double dof, Random random) {
        super(random);
        this.dof = dof;
        this.chisq = new ChiSquaredDistribution(dof, random);
    }

    public ChiDistribution(double dof, RandomFactory random) {
        super(random);
        this.dof = dof;
        this.chisq = new ChiSquaredDistribution(dof, random);
    }

    @Override
    public double nextRandom() {
        return FastMath.sqrt(this.chisq.nextRandom());
    }

    @Override
    public double pdf(double val) {
        return ChiDistribution.pdf(val, this.dof);
    }

    public static double pdf(double val, double dof) {
        if (val <= 0.0 || val == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double k = dof * 0.5;
        return FastMath.exp((dof - 1.0) * FastMath.log(val) + (1.0 - k) * MathUtil.LOG2 - GammaDistribution.logGamma(k) - val * val / 2.0);
    }

    @Override
    public double logpdf(double val) {
        return ChiDistribution.logpdf(val, this.dof);
    }

    public static double logpdf(double val, double dof) {
        if (val <= 0.0 || val == Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double k = dof * 0.5;
        return (dof - 1.0) * FastMath.log(val) + (1.0 - k) * MathUtil.LOG2 - GammaDistribution.logGamma(k) - val * val / 2.0;
    }

    @Override
    public double cdf(double val) {
        return ChiDistribution.cdf(val, this.dof);
    }

    public static double cdf(double val, double dof) {
        double v = val * val * 0.5;
        return val < 0.0 ? 0.0 : (v < Double.POSITIVE_INFINITY ? GammaDistribution.regularizedGammaP(dof * 0.5, v) : (v == v ? 1.0 : Double.NaN));
    }

    @Override
    public double quantile(double val) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        return "ChiDistribution(dof=" + this.dof + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID DOF_ID = ChiSquaredDistribution.Parameterizer.DOF_ID;
        double dof;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter dofP = new DoubleParameter(DOF_ID);
            if (config.grab(dofP)) {
                this.dof = dofP.doubleValue();
            }
        }

        @Override
        protected ChiDistribution makeInstance() {
            return new ChiDistribution(this.dof, this.rnd);
        }
    }
}

