/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class ChiSquaredDistribution
extends GammaDistribution {
    public ChiSquaredDistribution(double dof) {
        this(dof, (Random)null);
    }

    public ChiSquaredDistribution(double dof, Random random) {
        super(0.5 * dof, 0.5, random);
    }

    public ChiSquaredDistribution(double dof, RandomFactory random) {
        super(0.5 * dof, 0.5, random);
    }

    public static double cdf(double val, double dof) {
        return ChiSquaredDistribution.regularizedGammaP(0.5 * dof, 0.5 * val);
    }

    public static double pdf(double x, double dof) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (dof <= 0.0) {
            return Double.NaN;
        }
        double k = dof * 0.5;
        return Math.abs(k - 1.0) < Double.MIN_NORMAL ? FastMath.exp(-x * 2.0) * 2.0 : FastMath.exp((k - 1.0) * FastMath.log(x * 2.0) - x * 2.0 - ChiSquaredDistribution.logGamma(k)) * 2.0;
    }

    public static double logpdf(double x, double dof) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (dof <= 0.0) {
            return Double.NaN;
        }
        double k = dof * 0.5;
        double twox = x * 2.0;
        return twox == Double.POSITIVE_INFINITY ? Double.NEGATIVE_INFINITY : (k - 1.0) * FastMath.log(twox) - twox - ChiSquaredDistribution.logGamma(k) + MathUtil.LOG2;
    }

    @Reference(authors="D. J. Best, D. E. Roberts", title="Algorithm AS 91: The percentage points of the \u03c7\u00b2 distribution", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)", url="https://doi.org/10.2307/2347113", bibkey="doi:10.2307/2347113")
    public static double quantile(double x, double dof) {
        return GammaDistribution.quantile(x, 0.5 * dof, 0.5);
    }

    @Override
    public String toString() {
        return "ChiSquaredDistribution(dof=" + 2.0 * this.getK() + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID DOF_ID = new OptionID("distribution.chi.dof", "Chi distribution degrees of freedom parameter.");
        double dof;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter dofP = new DoubleParameter(DOF_ID);
            if (config.grab(dofP)) {
                this.dof = dofP.doubleValue();
            }
        }

        @Override
        protected ChiSquaredDistribution makeInstance() {
            return new ChiSquaredDistribution(this.dof, this.rnd);
        }
    }
}

