/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class ConstantDistribution
implements Distribution {
    final double c;

    public ConstantDistribution(double c) {
        this.c = c;
    }

    @Override
    public double nextRandom() {
        return this.c;
    }

    public double pmf(double val) {
        return val == this.c ? 1.0 : 0.0;
    }

    @Override
    public double pdf(double val) {
        return val == this.c ? Double.MAX_VALUE : 0.0;
    }

    @Override
    public double logpdf(double val) {
        return val == this.c ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double cdf(double val) {
        return val < this.c ? 0.0 : 1.0;
    }

    @Override
    public double quantile(double val) {
        return this.c;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID CONSTANT_ID = new OptionID("distribution.constant", "Constant value.");
        double constant;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter constP = new DoubleParameter(CONSTANT_ID);
            if (config.grab(constP)) {
                this.constant = constP.doubleValue();
            }
        }

        @Override
        protected ConstantDistribution makeInstance() {
            return new ConstantDistribution(this.constant);
        }
    }
}

