/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class ExpGammaDistribution
extends AbstractDistribution {
    private final double k;
    private final double theta;
    private final double shift;

    public ExpGammaDistribution(double k, double theta, double shift, Random random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
        this.shift = shift;
    }

    public ExpGammaDistribution(double k, double theta, double shift, RandomFactory random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
        this.shift = shift;
    }

    public ExpGammaDistribution(double k, double theta, double shift) {
        this(k, theta, shift, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return ExpGammaDistribution.pdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double logpdf(double val) {
        return ExpGammaDistribution.logpdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double cdf(double val) {
        return ExpGammaDistribution.cdf(val, this.k, this.theta, this.shift);
    }

    @Override
    public double quantile(double val) {
        return ExpGammaDistribution.quantile(val, this.k, this.theta, this.shift);
    }

    @Override
    public double nextRandom() {
        return ExpGammaDistribution.quantile(this.random.nextDouble(), this.k, this.theta, this.shift);
    }

    @Override
    public String toString() {
        return "ExpGammaDistribution(k=" + this.k + ", theta=" + this.theta + ", shift=" + this.shift + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double x, double k, double theta, double shift) {
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x != x) {
            return Double.NaN;
        }
        double e = FastMath.exp((x - shift) * theta);
        return e < Double.POSITIVE_INFINITY ? GammaDistribution.regularizedGammaP(k, e) : 1.0;
    }

    public static double logcdf(double x, double k, double theta, double shift) {
        double e = FastMath.exp((x - shift) * theta);
        return e < Double.POSITIVE_INFINITY ? GammaDistribution.logregularizedGammaP(k, e) : 0.0;
    }

    public static double pdf(double x, double k, double theta, double shift) {
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x != x) {
            return Double.NaN;
        }
        double ex = FastMath.exp(x = (x - shift) * theta);
        return ex < Double.POSITIVE_INFINITY ? FastMath.exp(k * x - ex - GammaDistribution.logGamma(k)) * theta : 0.0;
    }

    public static double logpdf(double x, double k, double theta, double shift) {
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x != x) {
            return Double.NaN;
        }
        double ex = FastMath.exp(x = (x - shift) * theta);
        return ex < Double.POSITIVE_INFINITY ? k * x - ex - GammaDistribution.logGamma(k) + FastMath.log(theta) : Double.NEGATIVE_INFINITY;
    }

    public static double quantile(double p, double k, double theta, double shift) {
        return FastMath.log(GammaDistribution.quantile(p, k, 1.0)) / theta + shift;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID THETA_ID = GammaDistribution.Parameterizer.THETA_ID;
        public static final OptionID K_ID = GammaDistribution.Parameterizer.K_ID;
        public static final OptionID SHIFT_ID = new OptionID("distribution.expgamma.shift", "Shift offset parameter.");
        double k;
        double theta;
        double shift;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter shiftP;
            DoubleParameter thetaP;
            super.makeOptions(config);
            DoubleParameter kP = new DoubleParameter(K_ID);
            if (config.grab(kP)) {
                this.k = kP.doubleValue();
            }
            if (config.grab(thetaP = new DoubleParameter(THETA_ID))) {
                this.theta = thetaP.doubleValue();
            }
            if (config.grab(shiftP = (DoubleParameter)new DoubleParameter(SHIFT_ID).setDefaultValue((Object)0.0))) {
                this.shift = shiftP.doubleValue();
            }
        }

        @Override
        protected ExpGammaDistribution makeInstance() {
            return new ExpGammaDistribution(this.k, this.theta, this.shift, this.rnd);
        }
    }
}

