/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

public class ExponentialDistribution
extends AbstractDistribution {
    double rate;
    double location;

    public ExponentialDistribution(double rate) {
        this(rate, 0.0, (Random)null);
    }

    public ExponentialDistribution(double rate, double location) {
        this(rate, location, (Random)null);
    }

    public ExponentialDistribution(double rate, Random random) {
        this(rate, 0.0, random);
    }

    public ExponentialDistribution(double rate, double location, Random random) {
        super(random);
        this.rate = rate;
        this.location = location;
    }

    public ExponentialDistribution(double rate, double location, RandomFactory random) {
        super(random);
        this.rate = rate;
        this.location = location;
    }

    public double getRate() {
        return this.rate;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double pdf(double val) {
        return val < this.location ? 0.0 : this.rate * FastMath.exp(-this.rate * (val - this.location));
    }

    @Override
    public double logpdf(double val) {
        return val < this.location ? Double.NEGATIVE_INFINITY : FastMath.log(this.rate) - this.rate * (val - this.location);
    }

    public static double pdf(double val, double rate) {
        return val < 0.0 ? 0.0 : rate * FastMath.exp(-rate * val);
    }

    public static double logpdf(double val, double rate) {
        return val < 0.0 ? Double.NEGATIVE_INFINITY : FastMath.log(rate) - rate * val;
    }

    @Override
    public double cdf(double val) {
        return val < this.location ? 0.0 : 1.0 - FastMath.exp(-this.rate * (val - this.location));
    }

    public static double cdf(double val, double rate) {
        return val < 0.0 ? 0.0 : 1.0 - FastMath.exp(-rate * val);
    }

    @Override
    public double quantile(double val) {
        return val >= 0.0 && val <= 1.0 ? -FastMath.log(1.0 - val) / this.rate + this.location : Double.NaN;
    }

    public static double quantile(double val, double rate) {
        return val >= 0.0 && val <= 1.0 ? -FastMath.log(1.0 - val) / rate : Double.NaN;
    }

    @Override
    public double nextRandom() {
        return -FastMath.log(this.random.nextDouble()) / this.rate + this.location;
    }

    @Override
    public String toString() {
        return "ExponentialDistribution(rate=" + this.rate + ", location=" + this.location + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("distribution.exponential.rate", "Exponential distribution rate (lambda) parameter (inverse of scale).");
        double location;
        double rate;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter rateP;
            super.makeOptions(config);
            DoubleParameter locP = new DoubleParameter(LOCATION_ID, 0.0);
            if (config.grab(locP)) {
                this.location = locP.doubleValue();
            }
            if (config.grab(rateP = new DoubleParameter(RATE_ID))) {
                this.rate = rateP.doubleValue();
            }
        }

        @Override
        protected ExponentialDistribution makeInstance() {
            return new ExponentialDistribution(this.rate, this.location, this.rnd);
        }
    }
}

