/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"exgaussian"})
public class ExponentiallyModifiedGaussianDistribution
extends AbstractDistribution {
    private double mean;
    private double stddev;
    private double lambda;

    public ExponentiallyModifiedGaussianDistribution(double mean, double stddev, double lambda, Random random) {
        super(random);
        this.mean = mean;
        this.stddev = stddev;
        this.lambda = lambda;
    }

    public ExponentiallyModifiedGaussianDistribution(double mean, double stddev, double lambda, RandomFactory random) {
        super(random);
        this.mean = mean;
        this.stddev = stddev;
        this.lambda = lambda;
    }

    public ExponentiallyModifiedGaussianDistribution(double mean, double stddev, double lambda) {
        this(mean, stddev, lambda, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return ExponentiallyModifiedGaussianDistribution.pdf(val, this.mean, this.stddev, this.lambda);
    }

    @Override
    public double logpdf(double val) {
        return ExponentiallyModifiedGaussianDistribution.logpdf(val, this.mean, this.stddev, this.lambda);
    }

    @Override
    public double cdf(double val) {
        return ExponentiallyModifiedGaussianDistribution.cdf(val, this.mean, this.stddev, this.lambda);
    }

    @Override
    @Deprecated
    public double quantile(double q) {
        return ExponentiallyModifiedGaussianDistribution.quantile(q, this.mean, this.stddev, this.lambda);
    }

    @Override
    public double nextRandom() {
        double no = this.mean + this.random.nextGaussian() * this.stddev;
        double ex = -FastMath.log(this.random.nextDouble()) / this.lambda;
        return no + ex;
    }

    @Override
    public String toString() {
        return "ExGaussianDistribution(mean=" + this.mean + ", stddev=" + this.stddev + ", lambda=" + this.lambda + ")";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStddev() {
        return this.stddev;
    }

    public double getLambda() {
        return this.lambda;
    }

    public static double pdf(double x, double mu, double sigma, double lambda) {
        double lss = lambda * sigma * sigma;
        double dx = x - mu;
        double erfc = NormalDistribution.erfc((lss - dx) / (sigma * MathUtil.SQRT2));
        return erfc > 0.0 ? 0.5 * lambda * FastMath.exp(lambda * (lss * 0.5 - dx)) * erfc : (x == x ? 0.0 : Double.NaN);
    }

    public static double logpdf(double x, double mu, double sigma, double lambda) {
        double lss = lambda * sigma * sigma;
        double dx = x - mu;
        double erfc = NormalDistribution.erfc((lss - dx) / (sigma * MathUtil.SQRT2));
        return erfc > 0.0 ? FastMath.log(0.5 * lambda * erfc) + lambda * (lss * 0.5 - dx) : (x == x ? Double.NEGATIVE_INFINITY : Double.NaN);
    }

    public static double cdf(double x, double mu, double sigma, double lambda) {
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        double u = lambda * (x - mu);
        double v = lambda * sigma;
        double v2 = v * v;
        double logphi = FastMath.log(NormalDistribution.cdf(u, v2, v));
        return NormalDistribution.cdf(u, 0.0, v) - FastMath.exp(-u + v2 * 0.5 + logphi);
    }

    @Deprecated
    public static double quantile(double x, double mu, double sigma, double lambda) {
        throw new NotImplementedException();
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID RATE_ID = ExponentialDistribution.Parameterizer.RATE_ID;
        double mean;
        double stddev;
        double lambda;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter rateP;
            DoubleParameter scaleP;
            super.makeOptions(config);
            DoubleParameter locP = (DoubleParameter)new DoubleParameter(LOCATION_ID).setDefaultValue((Object)0.0);
            if (config.grab(locP)) {
                this.mean = locP.doubleValue();
            }
            if (config.grab(scaleP = new DoubleParameter(SCALE_ID))) {
                this.stddev = scaleP.doubleValue();
            }
            if (config.grab(rateP = new DoubleParameter(RATE_ID))) {
                this.lambda = rateP.doubleValue();
            }
        }

        @Override
        protected ExponentiallyModifiedGaussianDistribution makeInstance() {
            return new ExponentiallyModifiedGaussianDistribution(this.mean, this.stddev, this.lambda, this.rnd);
        }
    }
}

