/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.data.synthetic.bymodel.distribution.GammaDistribution"})
public class GammaDistribution
extends AbstractDistribution {
    public static final double EULERS_CONST = 0.5772156649015329;
    static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    static final double NUM_PRECISION = 1.0E-15;
    static final int MAX_ITERATIONS = 1000;
    private final double k;
    private final double theta;

    public GammaDistribution(double k, double theta, Random random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
    }

    public GammaDistribution(double k, double theta, RandomFactory random) {
        super(random);
        if (!(k > 0.0) || !(theta > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + k + " " + theta);
        }
        this.k = k;
        this.theta = theta;
    }

    public GammaDistribution(double k, double theta) {
        this(k, theta, (Random)null);
    }

    @Override
    public double pdf(double val) {
        return GammaDistribution.pdf(val, this.k, this.theta);
    }

    @Override
    public double logpdf(double val) {
        return GammaDistribution.logpdf(val, this.k, this.theta);
    }

    @Override
    public double cdf(double val) {
        return GammaDistribution.cdf(val, this.k, this.theta);
    }

    @Override
    public double quantile(double val) {
        return GammaDistribution.quantile(val, this.k, this.theta);
    }

    @Override
    public double nextRandom() {
        return GammaDistribution.nextRandom(this.k, this.theta, this.random);
    }

    @Override
    public String toString() {
        return "GammaDistribution(k=" + this.k + ", theta=" + this.theta + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double val, double k, double theta) {
        if (val < 0.0) {
            return 0.0;
        }
        double vt = val * theta;
        return vt == Double.POSITIVE_INFINITY ? 1.0 : GammaDistribution.regularizedGammaP(k, vt);
    }

    public static double logcdf(double val, double k, double theta) {
        if (val < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double vt = val * theta;
        return val == Double.POSITIVE_INFINITY ? 0.0 : GammaDistribution.logregularizedGammaP(k, vt);
    }

    public static double pdf(double x, double k, double theta) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0) {
            return k == 1.0 ? theta : 0.0;
        }
        if (k == 1.0) {
            return FastMath.exp(-x * theta) * theta;
        }
        double xt = x * theta;
        return xt == Double.POSITIVE_INFINITY ? 0.0 : FastMath.exp((k - 1.0) * FastMath.log(xt) - xt - GammaDistribution.logGamma(k)) * theta;
    }

    public static double logpdf(double x, double k, double theta) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            return k == 1.0 ? FastMath.log(theta) : Double.NEGATIVE_INFINITY;
        }
        if (k == 1.0) {
            return FastMath.log(theta) - x * theta;
        }
        double xt = x * theta;
        return xt == Double.POSITIVE_INFINITY ? Double.NEGATIVE_INFINITY : FastMath.log(theta) + (k - 1.0) * FastMath.log(xt) - xt - GammaDistribution.logGamma(k);
    }

    public static double logGamma(double x) {
        if (Double.isNaN(x) || x <= 0.0) {
            return Double.NaN;
        }
        double g = 4.7421875;
        double tmp = x + g + 0.5;
        tmp = (x + 0.5) * FastMath.log(tmp) - tmp;
        double ser = LANCZOS[0];
        for (int i = LANCZOS.length - 1; i > 0; --i) {
            ser += LANCZOS[i] / (x + (double)i);
        }
        return tmp + FastMath.log(MathUtil.SQRTTWOPI * ser / x);
    }

    public static double gamma(double x) {
        return FastMath.exp(GammaDistribution.logGamma(x));
    }

    public static double regularizedGammaP(double a, double x) {
        double term;
        if (Double.isInfinite(a) || Double.isInfinite(x) || !(a > 0.0) || !(x >= 0.0)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x >= a + 1.0) {
            return 1.0 - GammaDistribution.regularizedGammaQ(a, x);
        }
        double sum = term = 1.0 / a;
        for (int n = 1; n < 1000; ++n) {
            if ((sum += (term = x / (a + (double)n) * term)) == Double.POSITIVE_INFINITY) {
                return 1.0;
            }
            if (Math.abs(term / sum) < 1.0E-15) break;
        }
        return FastMath.exp(-x + a * FastMath.log(x) - GammaDistribution.logGamma(a)) * sum;
    }

    public static double logregularizedGammaP(double a, double x) {
        double del;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x >= a + 1.0) {
            return FastMath.log(1.0 - GammaDistribution.regularizedGammaQ(a, x));
        }
        double sum = del = 1.0 / a;
        for (int n = 1; n < Integer.MAX_VALUE && !(Math.abs((del *= x / (a + (double)n)) / (sum += del)) < 1.0E-15) && !(sum >= Double.POSITIVE_INFINITY); ++n) {
        }
        if (Double.isInfinite(sum)) {
            return 0.0;
        }
        return -x + a * FastMath.log(x) - GammaDistribution.logGamma(a) + FastMath.log(sum);
    }

    public static double regularizedGammaQ(double a, double x) {
        double d;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 1.0;
        }
        if (x < a + 1.0) {
            return 1.0 - GammaDistribution.regularizedGammaP(a, x);
        }
        double FPMIN = 4.940656458412465E-309;
        double b = x + 1.0 - a;
        double c = Double.POSITIVE_INFINITY;
        double fac = d = 1.0 / b;
        for (int i = 1; i < 1000; ++i) {
            double an = (double)i * (a - (double)i);
            if (Math.abs(d = an * d + (b += 2.0)) < 4.940656458412465E-309) {
                d = 4.940656458412465E-309;
            }
            if (Math.abs(c = b + an / c) < 4.940656458412465E-309) {
                c = 4.940656458412465E-309;
            }
            d = 1.0 / d;
            double del = d * c;
            fac *= del;
            if (Math.abs(del - 1.0) <= 1.0E-15) break;
        }
        return fac * FastMath.exp(-x + a * FastMath.log(x) - GammaDistribution.logGamma(a));
    }

    @References(value={@Reference(authors="J. H. Ahrens, U. Dieter", title="Computer methods for sampling from gamma, beta, Poisson and binomial distributions", booktitle="Computing 12", url="https://doi.org/10.1007/BF02293108", bibkey="DBLP:journals/computing/AhrensD74"), @Reference(authors="J. H. Ahrens, U. Dieter", title="Generating gamma variates by a modified rejection technique", booktitle="Communications of the ACM 25", url="https://doi.org/10.1145/358315.358390", bibkey="DBLP:journals/cacm/AhrensD82")})
    public static double nextRandom(double k, double theta, Random random) {
        double w;
        double u;
        double sign_u;
        double e;
        double t;
        double q;
        double v;
        double c;
        double si;
        double b;
        double q0;
        double tv2;
        double tv1;
        double tv12;
        double d;
        double s;
        double ss;
        double q1 = 0.0416666664;
        double q2 = 0.0208333723;
        double q3 = 0.0079849875;
        double q4 = 0.0015746717;
        double q5 = -3.349403E-4;
        double q6 = 3.340332E-4;
        double q7 = 6.053049E-4;
        double q8 = -4.701849E-4;
        double q9 = 1.71032E-4;
        double a1 = 0.333333333;
        double a2 = -0.249999949;
        double a3 = 0.199999867;
        double a4 = -0.166677482;
        double a5 = 0.142873973;
        double a6 = -0.124385581;
        double a7 = 0.11036831;
        double a8 = -0.112750886;
        double a9 = 0.104089866;
        double e1 = 1.0;
        double e2 = 0.499999994;
        double e3 = 0.166666848;
        double e4 = 0.041664508;
        double e5 = 0.008345522;
        double e6 = 0.001353826;
        double e7 = 2.47453E-4;
        if (k < 1.0) {
            double gds;
            double b2 = 1.0 + 0.36788794412 * k;
            while (true) {
                double p;
                if ((p = b2 * random.nextDouble()) <= 1.0) {
                    gds = FastMath.exp(FastMath.log(p) / k);
                    if (!(FastMath.log(random.nextDouble()) <= -gds)) continue;
                    return gds / theta;
                }
                gds = -FastMath.log((b2 - p) / k);
                if (FastMath.log(random.nextDouble()) <= (k - 1.0) * FastMath.log(gds)) break;
            }
            return gds / theta;
        }
        if (k != -1.0) {
            ss = k - 0.5;
            s = FastMath.sqrt(ss);
            d = 5.656854249 - 12.0 * s;
        } else {
            ss = 0.0;
            s = 0.0;
            d = 0.0;
        }
        while ((tv12 = (tv1 = 2.0 * random.nextDouble() - 1.0) * tv1 + (tv2 = 2.0 * random.nextDouble() - 1.0) * tv2) > 1.0) {
        }
        double v1 = tv1;
        double v12 = tv12;
        double t2 = v1 * FastMath.sqrt(-2.0 * FastMath.log(v12) / v12);
        double x = s + 0.5 * t2;
        double gds = x * x;
        if (t2 >= 0.0) {
            return gds / theta;
        }
        double un = random.nextDouble();
        if (d * un <= t2 * t2 * t2) {
            return gds / theta;
        }
        if (k != -1.0) {
            double r = 1.0 / k;
            q0 = ((((((((1.71032E-4 * r + -4.701849E-4) * r + 6.053049E-4) * r + 3.340332E-4) * r + -3.349403E-4) * r + 0.0015746717) * r + 0.0079849875) * r + 0.0208333723) * r + 0.0416666664) * r;
            if (k > 3.686) {
                if (k > 13.022) {
                    b = 1.77;
                    si = 0.75;
                    c = 0.1515 / s;
                } else {
                    b = 1.654 + 0.0076 * ss;
                    si = 1.68 / s + 0.275;
                    c = 0.062 / s + 0.024;
                }
            } else {
                b = 0.463 + s - 0.178 * ss;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.016 * s;
            }
        } else {
            b = 0.0;
            c = 0.0;
            si = 0.0;
            q0 = 0.0;
        }
        if (x > 0.0) {
            v = t2 / (s + s);
            q = Math.abs(v) > 0.25 ? q0 - s * t2 + 0.25 * t2 * t2 + (ss + ss) * FastMath.log(1.0 + v) : q0 + 0.5 * t2 * t2 * ((((((((0.104089866 * v + -0.112750886) * v + 0.11036831) * v + -0.124385581) * v + 0.142873973) * v + -0.166677482) * v + 0.199999867) * v + -0.249999949) * v + 0.333333333) * v;
            if (FastMath.log(1.0 - un) <= q) {
                return gds / theta;
            }
        }
        do {
            e = -FastMath.log(random.nextDouble());
            u = random.nextDouble();
        } while ((t = b + e * si * (sign_u = (u = u + u - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (q = Math.abs(v = t / (s + s)) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * FastMath.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((0.104089866 * v + -0.112750886) * v + 0.11036831) * v + -0.124385581) * v + 0.142873973) * v + -0.166677482) * v + 0.199999867) * v + -0.249999949) * v + 0.333333333) * v) <= 0.0 || !(c * u * sign_u <= (w = q > 0.5 ? FastMath.exp(q) - 1.0 : ((((((2.47453E-4 * q + 0.001353826) * q + 0.008345522) * q + 0.041664508) * q + 0.166666848) * q + 0.499999994) * q + 1.0) * q) * FastMath.exp(e - 0.5 * t * t)));
        double x2 = s + 0.5 * t;
        return x2 * x2 / theta;
    }

    @Reference(authors="D. J. Best, D. E. Roberts", title="Algorithm AS 91: The percentage points of the \u03c7\u00b2 distribution", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)", url="https://doi.org/10.2307/2347113", bibkey="doi:10.2307/2347113")
    protected static double chisquaredProbitApproximation(double p, double nu, double g) {
        double delta;
        double EPS1 = 1.0E-14;
        if (Double.isNaN(p) || Double.isNaN(nu)) {
            return Double.NaN;
        }
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (nu <= 0.0) {
            return Double.NaN;
        }
        double k = 0.5 * nu;
        double logp = FastMath.log(p);
        if (nu < -1.24 * logp) {
            return FastMath.pow(p * k * FastMath.exp(g + k * MathUtil.LOG2), 1.0 / k);
        }
        if (nu > 0.32) {
            double p1;
            double x = NormalDistribution.quantile(p, 0.0, 1.0);
            double a = x * FastMath.sqrt(p1 = 2.0 / (9.0 * nu)) + 1.0 - p1;
            double ch = nu * a * a * a;
            if (ch > 2.2 * nu + 6.0) {
                ch = -2.0 * (FastMath.log1p(-p) - (k - 1.0) * FastMath.log(0.5 * ch) + g);
            }
            return ch;
        }
        double C7 = 4.67;
        double C8 = 6.66;
        double C9 = 6.73;
        double C10 = 13.32;
        double ag = FastMath.log1p(-p) + g + (k - 1.0) * MathUtil.LOG2;
        double ch = 0.4;
        do {
            double p1 = 1.0 + ch * (4.67 + ch);
            double p2 = ch * (6.73 + ch * (6.66 + ch));
            double t = -0.5 + (4.67 + 2.0 * ch) / p1 - (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
            delta = (1.0 - FastMath.exp(ag + 0.5 * ch) * p2 / p1) / t;
            ch -= delta;
        } while (!(Math.abs(delta) <= 1.0E-14 * Math.abs(ch)));
        return ch;
    }

    @Reference(authors="D. J. Best, D. E. Roberts", title="Algorithm AS 91: The percentage points of the \u03c7\u00b2 distribution", booktitle="Journal of the Royal Statistical Society. Series C (Applied Statistics)", url="https://doi.org/10.2307/2347113", bibkey="doi:10.2307/2347113")
    public static double quantile(double p, double k, double theta) {
        double ch;
        int max_newton_iterations;
        block17: {
            double g;
            double EPS2 = 5.0E-7;
            int MAXIT = 1000;
            if (!(p >= 0.0) || p > 1.0 || Double.isNaN(k) || Double.isNaN(theta)) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return 0.0;
            }
            if (p == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (k < 0.0 || theta <= 0.0) {
                return Double.NaN;
            }
            if (k == 0.0) {
                return 0.0;
            }
            max_newton_iterations = 1;
            if (k < 1.0E-10) {
                max_newton_iterations = 7;
            }
            if (Double.isInfinite(ch = GammaDistribution.chisquaredProbitApproximation(p, 2.0 * k, g = GammaDistribution.logGamma(k)))) {
                max_newton_iterations = 0;
            } else if (ch < 5.0E-7) {
                max_newton_iterations = 20;
            } else if (p > 0.99999999999999 || p < 1.0E-100) {
                max_newton_iterations = 20;
            } else {
                double c = k - 1.0;
                double ch0 = ch;
                for (int i = 1; i <= 1000; ++i) {
                    double s6;
                    double s5;
                    double s4;
                    double s3;
                    double s2;
                    double b;
                    double a;
                    double s1;
                    double t;
                    double q = ch;
                    double p1 = 0.5 * ch;
                    double p2 = p - GammaDistribution.regularizedGammaP(k, p1);
                    if (Double.isInfinite(p2) || ch <= 0.0) {
                        ch = ch0;
                        max_newton_iterations = 27;
                    } else if (!(Math.abs(q - (ch += (t = p2 * FastMath.exp(k * MathUtil.LOG2 + g + p1 - c * FastMath.log(ch))) * (1.0 + 0.5 * t * (s1 = (210.0 + (a = 0.5 * t - (b = t / ch) * c) * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0) - b * c * (s1 - b * ((s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0) - b * ((s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0) - b * ((s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0) - b * ((s5 = (84.0 + 2264.0 * a + c * (1175.0 + 606.0 * a)) / 2520.0) - b * (s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0))))))))) < 5.0E-7 * ch)) {
                        if (!(Math.abs(q - ch) > 0.1 * Math.abs(ch))) continue;
                        ch = (ch < q ? 0.9 : 1.1) * q;
                        continue;
                    }
                    break block17;
                }
                LoggingUtil.warning("No convergence in AS 91 Gamma probit.");
            }
        }
        double x = 0.5 * ch / theta;
        if (max_newton_iterations > 0) {
            x = GammaDistribution.gammaQuantileNewtonRefinement(FastMath.log(p), k, theta, max_newton_iterations, x);
        }
        return x;
    }

    protected static double gammaQuantileNewtonRefinement(double logpt, double k, double theta, int maxit, double x) {
        double newx;
        double g;
        double logpe;
        double EPS_N = 1.0E-15;
        if (x <= 0.0) {
            x = Double.MIN_NORMAL;
        }
        double logpc = GammaDistribution.logcdf(x, k, theta);
        if (x == Double.MIN_NORMAL && logpc > logpt * 1.0000001) {
            return 0.0;
        }
        if (logpc == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        for (int i = 0; !(i >= maxit || Math.abs(logpe = logpc - logpt) < Math.abs(1.0E-15 * logpt) || (g = GammaDistribution.logpdf(x, k, theta)) == Double.NEGATIVE_INFINITY || Math.abs((logpc = GammaDistribution.logcdf(newx = x - logpe * FastMath.exp(logpc - g), k, theta)) - logpt) > Math.abs(logpe) || i > 0 && Math.abs(logpc - logpt) == Math.abs(logpe)); ++i) {
            x = newx;
        }
        return x;
    }

    @Reference(authors="J. M. Bernando", title="Algorithm AS 103: Psi (Digamma) Function", booktitle="Statistical Algorithms", url="https://doi.org/10.2307/2347257", bibkey="doi:10.2307/2347257")
    public static double digamma(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / x;
        }
        if (x > 49.0) {
            double ix2 = 1.0 / (x * x);
            return FastMath.log(x) - 0.5 / x - ix2 * (0.08333333333333333 + ix2 * (0.008333333333333333 - ix2 / 252.0));
        }
        return GammaDistribution.digamma(x + 1.0) - 1.0 / x;
    }

    public static double trigamma(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x <= 1.0E-5) {
            return 1.0 / (x * x);
        }
        if (x > 49.0) {
            double ix2 = 1.0 / (x * x);
            return 1.0 / x - ix2 / 2.0 + ix2 / x * (0.16666666666666666 - ix2 * (0.03333333333333333 + ix2 / 42.0));
        }
        return GammaDistribution.trigamma(x + 1.0) - 1.0 / (x * x);
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID K_ID = new OptionID("distribution.gamma.k", "Gamma distribution k = alpha parameter.");
        public static final OptionID THETA_ID = new OptionID("distribution.gamma.theta", "Gamma distribution theta = 1/beta parameter.");
        double k;
        double theta;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter thetaP;
            super.makeOptions(config);
            DoubleParameter kP = new DoubleParameter(K_ID);
            if (config.grab(kP)) {
                this.k = kP.doubleValue();
            }
            if (config.grab(thetaP = new DoubleParameter(THETA_ID))) {
                this.theta = thetaP.doubleValue();
            }
        }

        @Override
        protected GammaDistribution makeInstance() {
            return new GammaDistribution(this.k, this.theta, this.rnd);
        }
    }
}

